; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	FUNCTION p_newhead
;
; PURPOSE:
;	Create empty PDS header
;
; CALLING SEQUENCE:
;	 Result = p_newhead()
;
; INPUTS:
;   None
;
; RETURNS:
;	basic empty PDS header structure
;   image:  the output image
;
; KEYWORD PARAMETERS:
;	NONE
;
; MODIFICATION HISTORY:
; 	Written by:	Stubbe F. Hviid, 12/05-2004
;-
FUNCTION p_newhead

	tags = ['PDS_VERSION_ID', '', 'RECORD_TYPE', 'RECORD_BYTES', 'FILE_RECORDS', 'LABEL_RECORDS', 'FILE_NAME', '', '']
	values = ['PDS3', '/* FILE SPCIFICATIONS */', 'FIXED_LENGTH', '512', '0', '0', 'NULL', '/* POINTERS TO DATA OBJECTS */', '/* SYSTEM LABELS */']

	return, {type: 'TAGHDR', filename: '', tags: tags, values: values}
END