FUNCTION p_load_help_text, file

	openr, unit, file, /get_lun

	out = ['']
	done = 0

	; find begin of help text
	while NOT eof(unit) AND NOT done do begin
		s = ''
		readf, unit, s
		if strmid(s, 0, 2) eq ';+' then done = 1
	endwhile

	; read help text
	done = 0
	while NOT eof(unit) AND NOT done do begin
		s = ''
		readf, unit, s
		if strmid(s, 0, 1) eq ';' then out = [out, s]
	endwhile

	close, unit
	free_lun, unit

	return, out
END

PRO p_whelp_event, ev

	widget_control, ev.top, GET_UVALUE=wid
	widget_control, ev.id, get_uvalue=uv

	if ev.id eq ev.top then begin
		widget_control, ev.id, XSIZE = ev.x, YSIZE=ev.y
		widget_control, ev.id, TLB_GET_SIZE=bs
		widget_control, wid.wtext, SCR_XSIZE = bs[0]-300, SCR_YSIZE=bs[1]
	endif else begin
		if uv eq 'PRINT' then begin
			widget_control, wid.wtext, GET_VALUE=text
			print_text, text
		endif
		if uv eq 'SAVE' then begin
			widget_control, wid.wtext, GET_VALUE=text
			save_text, '', text
		endif
		if uv eq 'LIST' then begin
			txt = p_load_help_text(wid.dir + '/' + wid.files[ev.index]);
			widget_control, wid.wtext, SET_VALUE=txt
		endif
	endelse

END

PRO p_whelp

	path = FILE_WHICH( 'p_whelp.pro', /INCLUDE_CURRENT_DIR)

	fn = p_parse_file_path(path)

	files = findfile(fn.dir + '/*.pro')

	for i=0, n_elements(files)-1 do begin
		tfn = p_parse_file_path(files[i])
		files[i] = tfn.filename
	endfor


	if n_elements(NO_BLOCK) eq 0 then NO_BLOCK=1
	if n_elements(MODAL) eq 0 then MODAL=0

	if n_elements(TITLE) eq 0 then TITLE = 'Fairwood Show Text' else TITLE = 'Fairwood Show Text - '+TITLE

	wbase = widget_base(XSIZE=800, YSIZE=500, /TLB_SIZE_EVENTS, MBAR=mbar, TITLE=TITLE, /ROW)
	wlist = widget_list(wbase, SCR_XSIZE = 300, UVALUE='LIST', VALUE=files)
	wtext = widget_text(wbase, FONT='*FIXED', /scroll, /frame, UVALUE='TEXT', SCR_XSIZE=500)
	wfile = widget_button(mbar, VALUE='File')
	wprint = widget_button(wfile, VALUE='Save', UVALUE='SAVE')
	wprint = widget_button(wfile, VALUE='Print', UVALUE='PRINT', /SEPARATOR)


	widget_control, wbase, SET_UVALUE={wtext: wtext, wlist: wlist, dir: fn.dir, files: files}

	widget_control, wbase, /REALIZE

	widget_control, wtext, SET_VALUE=text

	XManager, 'p_whelp', wbase, NO_BLOCK=NO_BLOCK, MODAL=MODAL

	WIDGET = wbase






END