; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	PRO p_close_stripeset, sh
;
; PURPOSE:
;	Function for handling huge image data files. A stripeset is an interface for reading the image data in segments from the disk
;   small enough that the image data will fit in memory.
; 	The function supports PDS and VICAR images
;
;	p_close_stripeset     stop stripeset handling and frees the file handle used by the stripeset read procedure
;
; CALLING SEQUENCE:
;	 p_close_stripeset, sh
;
; INPUTS:
;   st:			The structure returned by p_open_stripeset()
;
; RETURNS:
;	Nothing
;
; KEYWORD PARAMETERS:
;	None
;
; EXAMPLE:
;	st = p_open_stripeset(pickfile(), 2000)		; open stripe set using 2000 liner per read cycle
;   ok=1
;   while ok do begin
; 		image = p_read_stripe(st, OK=ok)	; read a stripe segment OK returns 0 on read failure (end of image)
; 		if ok ne 0 then tvscl, image
;   endwhile
;   p_stripe_close, st
;
; MODIFICATION HISTORY:
; 	Written by:	Stubbe F. Hviid, 12/05-2004
;-

PRO p_close_stripeset, sh
	if sh.type eq 'STRIPEHEAD' then begin
		close, sh.unit
		free_lun, sh.unit
	endif
END