; Copyright (c) 2006, Stubbe F. Hviid.  All rights reserved.
;   Unauthorized reproduction prohibited.
;+
; NAME:
;   FUNCTION p_string_decode, enc_string
;
; PURPOSE:
;   Expand a multiline encoded PDS string into a string array
;   (multiline encoded strings uses the \n code a line separator)
;
; CALLING SEQUENCE:
;    Result = p_string_decode, enc_string
;
; INPUTS:
;   enc_string:   The string to be decoded
;
; RETURNS:
;   strarr containg the decoded strings
;
; KEYWORD PARAMETERS:
;   None
;
; MODIFICATION HISTORY:
;   Written by:  Stubbe F. Hviid, 25/9-2006
;-

FUNCTION p_string_decode, enc_string

	tmp = enc_string

	p = strpos(tmp, '\n')

	out = ['']

	while p ge 0 do begin
		out = [out, strmid(tmp, 0, p)]
		tmp = strmid(tmp, p+2)
		p = strpos(tmp, '\n')
	endwhile
	out = [out, tmp]

	return, out[1:*]
END