; Copyright (c) 2004, Stubbe F. Hviid @ Max Planck Institut fur Sonnensystemforschung
;   Unauthorized reproduction prohibited.
;+
; NAME:
;   FUNCTION p_scet2et, scet
;
; PURPOSE:
;   Convert from ESA timeformat YYYY-MM-DDTHH:MM:SS.MMMZ to julian day
;
; CATEGORY:
;   Osiris CCD Calibration
;
; CALLING SEQUENCE:
;  Result = p_scet2et(scet)
;
; INPUTS:
;   scet:		Time string in the format YYYY-MM-DDTHH:MM:SS.MMMZ
;
; OPTIONAL INPUT:
;	None
;
; KEYWORD PARAMETERS:
;   None
;
; OUTPUTS:
;   None
;
; RETURNS:
;   julian day of time string (double)
;
; RESTRICTIONS:
;	None
;
; EXAMPLE:
;   print, p_scet2et, '2005-06-28T12:00:00.000Z'
;
; MODIFICATION HISTORY:
;   Written by:  Stubbe F. Hviid   1/7-2005
;-

FUNCTION p_scet2et, scet

	year = strmid(scet, 0, 4)
	month = strmid(scet, 5, 2)
	day = strmid(scet, 8, 2)

	hour = strmid(scet, 11, 2)
	minute = strmid(scet, 14, 2)
	sec = strmid(scet, 17, 2)
	msec = strmid(scet, 20, 3)

	return, julday(fix(month), fix(day), fix(year), fix(hour), fix(minute), fix(sec))
END