; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
; Unauthorized reproduction prohibited.
;+
; NAME:
; FUNCTION p_struct_tag_exists, struct, tag
;
; PURPOSE:
; Check if a named tag exists in an IDL structure
;
; CALLING SEQUENCE:
;  FUNCTION p_struct_tag_exists, struct, tag
;
; INPUTS:
;   struct:   The structure to be checked
;   tag:      The name of the tag to verified
;
; RETURNS:
; 1 if the tag exists
; 0 if the tag does not exists
;
; KEYWORD PARAMETERS:
; NONE
;
; EXAMPLE:
;   str = {a: 0, b: 1, c: 2}
;   if p_struct_tag_exists(str, 'a') eq 1 then print, str.a
;
; MODIFICATION HISTORY:
;   Written by: Stubbe F. Hviid, 24/2-2007
;-

FUNCTION p_struct_tag_exists, struct, tag

  names = tag_names(struct)
  
  s = where(names eq strupcase(tag))
  
  if s[0] lt 0 then return, 0
  
  return, 1
END