
PRO show_text_event, ev

	widget_control, ev.top, GET_UVALUE=wtext
	widget_control, ev.id, get_uvalue=uv

	if ev.id eq ev.top then begin
		widget_control, ev.id, XSIZE = ev.x, YSIZE=ev.y
		widget_control, ev.id, TLB_GET_SIZE=bs
		widget_control, wtext, SCR_XSIZE = bs[0], SCR_YSIZE=bs[1]
	endif else begin
		if uv eq 'PRINT' then begin
			widget_control, wtext, GET_VALUE=text
			print_text, text
		endif
		if uv eq 'SAVE' then begin
			widget_control, wtext, GET_VALUE=text
			save_text, '', text
		endif
	endelse

END


PRO p_show_text, text, NO_BLOCK=NO_BLOCK, MODAL=MODAL, TITLE=TITLE, WIDGET=WIDGET

	if n_elements(NO_BLOCK) eq 0 then NO_BLOCK=1
	if n_elements(MODAL) eq 0 then MODAL=0

	if n_elements(TITLE) eq 0 then TITLE = 'Fairwood Show Text' else TITLE = 'Fairwood Show Text - '+TITLE

	wbase = widget_base(XSIZE=500, YSIZE=500, /TLB_SIZE_EVENTS, MBAR=mbar, TITLE=TITLE)
	wtext = widget_text(wbase, SCR_XSIZE=500, SCR_YSIZE=500, FONT='*FIXED', /scroll, /frame, UVALUE='TEXT')
	wfile = widget_button(mbar, VALUE='File')
	wprint = widget_button(wfile, VALUE='Save', UVALUE='SAVE')
	wprint = widget_button(wfile, VALUE='Print', UVALUE='PRINT', /SEPARATOR)


	widget_control, wbase, SET_UVALUE=wtext

	widget_control, wbase, /REALIZE

	widget_control, wtext, SET_VALUE=text

	XManager, 'show_text', wbase, NO_BLOCK=NO_BLOCK, MODAL=MODAL

	WIDGET = wbase

END