;
; --------------------------------- plotPG -------------------------------------
;
pro plotPG,dir,GS

	sGS = string(GS,'(i2.2)')
	file = dir+'DFMS_PixelGainTable_20130101_FM_GS'+sGS+'.dat'
	;
	openr,1,file
	;
	str= ' '
	for i=1,39 do begin
    	readf,1,str
	endfor

	data = fltarr(5)
	ldata = fltarr(5,512)

	for ii=0,511 do begin
		readf,1,str
    	data = strsplit(str,',',/extract)
    	ldata(*,ii) = data
	endfor

	close,1

	window,4,xsize=800,ysize=1200

	!p.multi=[0,1,2]

	spos = strpos(file,'/',/reverse_search)
	tit = strmid(file,spos+1,100)

	plot,lData(0,*),ldata(3,*), title=tit+' - Row A',xtitle='Pixel',ytitle='Pixel Gain'
	oplot,[0,512],[0.0,0.0],linestyle=2
	xyouts,0.80,0.93,'Gain Step = '+sGS, /normal

	plot,lData(0,*),ldata(4,*), title=tit+' - Row B',xtitle='Pixel',ytitle='Pixel Gain'
	oplot,[0,512],[0.0,0.0],linestyle=2
	xyouts,0.80,0.43,'Gain Step = '+sGS, /normal
	
end
;
; ---------------------------------- Main --------------------------------------
;
dir = getenv('DFMS_INSTALL_DIR')+'/tables/Gain/FM/20130101/'

!p.charsize=1.3
!p.background = 255
!p.color = 0
loadct,39
	
GS=1
while (GS ge 1 OR GS le 16) do begin
	read,GS,prompt='Enter Pixel Gain Step Value [1-16 or 0 to Exit] : '
	if (GS eq 0) then begin
		close,1
		device,window_state=wState
    	if (wState[4]) then wdelete,4
		break
	endif else begin
		plotPG,dir,GS
	endelse
endwhile

end
