;
; ------------------------ convertToJD -------------------------------
;
pro convertToJD,sData,jd

	yr  = double(strmid(sData,0,4))
	mon = double(strmid(sData,4,2))
	day = double(strmid(sData,6,2))
	hr  = double(strmid(sData,9,2))
	min = double(strmid(sData,11,2))
	sec = double(strmid(sData,13,5))/1000.0
	
	jd = julday(mon,day,yr,hr,min,sec)
		
end
;
; ----------------------- convertToCal --------------------------------
;
pro convertToCal,time,cal

	caldat,time,mon,day,yr,hr,mn,sec
	mon = reform(mon)
	day = reform(day)
	yr = reform(yr)
	hr = reform(hr)
	mn = reform(mn)
	sec = reform(sec)
	
	cal = strarr(n_elements(mon))
	for i=0,n_elements(mon)-1 do begin
		cal[i] = string(day[i]+1, format='(i2.2)') + '/' + $
		         string(mon[i], format='(i2.2)') + '/' + $
		         string(yr[i], format='(i4.4)') + '-' + $
		         string(hr[i], format='(i2.2)') + ':' + $
		         string(mn[i], format='(i2.2)') + ':' + $
		         string(sec[i], format='(f06.3)')
	endfor

end
;
; ---------------------------- Main ----------------------------------
;
dir = getenv('DFMS_INSTALL_DIR')+'/timeSeries/'
str = ' '

sData = strarr(3)
dData = dblarr(3)
;

!p.charsize=1.3
!p.background = 255
!p.color = 0
loadct,39

if (!d.name eq 'X') then window,1,xsize=1000,ysize=600
	
while(1) do begin

	file = dialog_pickfile(path=dir, title='Select a time series file to plot')
    openr,1,file

    spos = strpos(file,'/',/reverse_search)
    mass = strmid(file,spos+23,2)
    ;stop
    
    k = 0
	while(not EOF(1)) do begin
		readf,1,str
		sData = strsplit(str,/extract)
		convertToJD,sData[0],jd
		densA = double(sData[1])
		densB = double(sData[2])
		dData = [jd,densA,densB]
		if (k eq 0) then begin
			tdata = dData
		endif else begin
		    tdata = [[tdata],[dData]]
		endelse
		k=k+1
	endwhile
	close,1

	time = reform(tdata[0,*])
    ; Sort the time from small to large
	time = time[sort(time)]

	dataA = reform(tdata[1,*])
    ; Use same time sort for data
	dataA = dataA[sort(time)]
	dataB = reform(tdata[2,*])
    ; Use same time sort for data
	dataB = dataB[sort(time)]
	
	convertToCal,time,cal
	
	;stop
	
	tit = 'Time History for Mass '+mass
	plot, time, dataA, /ylog, title=tit, xtitle='Julian Date',ytitle='Density (/cm^3)',psym=2
	oplot, time, dataB, psym=2
	
	read,str,prompt='Would you like to plot another time series? [Y/N] '
	str = strupcase(str)
	if (str eq 'N') then begin
	    wdelete,1
		break
	endif

endwhile

end
