
#ifndef DFMS_COPS_CLASS_H_
#define DFMS_COPS_CLASS_H_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_PDS_file_Class.hh"

//
// This Class represents the relevant data and methods that act on an COPS file
//
class DFMS_COPS_Class: public DFMS_PDS_file_Class {

	private:
		string pathC;
		string fileC;
		string fileDate;
		string COPSfile;
		int COPSHKrows;
		int COPSHKcols;

	public:
		map<string,string> COPSHKobj;
		str2D COPSHKdata;

	public:
		DFMS_COPS_Class(string, string, string);
		~DFMS_COPS_Class();
		int readCOPSHKdata(fstream &);
		int getCOPSdata();
		string getFileName() {return fileC;}
		string getFileDate() {return fileDate;}
		void printCOPSdata(string);

		static int getCOPSfilesInDir(string, string, vector<L2FileInfo> &);
		static int findBestCOPSfile(string, string, vector<L2FileInfo> &,
									vector<L2FileInfo> &, vector<L2FileInfo> &);
};

#endif //DFMS_COPS_CLASS_H_
