/*
 * DFMS_CreateGCUSLFPix0_Class.hh
 *
 *  Created on: Jun 26, 2014
 *      Author: marinaldi
 */

#ifndef DFMS_CREATEGCUSLFPIX0_CLASS_HH_
#define DFMS_CREATEGCUSLFPIX0_CLASS_HH_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_definedConstants.hh"
#include "DFMS_PDS_L2_file_Class.hh"
#include "DFMS_MPST_Class.hh"
#include "DFMS_PeakFit_Class.hh"
#include "DFMS_Gain_Table_Class.hh"
#include "DFMS_PixelGain_Table_Class.hh"
#include "DFMS_LinFit_Class.hh"
#include "DFMS_FindAllPeaks_Class.hh"
#include "DFMS_Histogram_Class.hh"
#include "DFMS_PolyFit_Class.hh"
#include "DFMS_X0FitFile_Class.hh"

extern string sx0FitsdataPath;
extern string sDiagPath;
extern int NUMPG;

// Vectors holding GCU,Pix0 mass tables for fitting purposes
extern vector<x0FitInfo> gcuLmLrA, gcuHmLrA, gcuLmLrB, gcuHmLrB;
extern vector<x0FitInfo> gcuLmHrA, gcuMmHrA, gcuHmHrA, gcuLmHrB, gcuMmHrB, gcuHmHrB;
// Vectors holding SLF,Pix0 mass tables for fitting purposes
extern vector<x0FitInfo> slfLmLrA, slfHmLrA, slfLmLrB, slfHmLrB;
extern vector<x0FitInfo> slfLmHrA, slfMmHrA, slfHmHrA, slfLmHrB, slfMmHrB, slfHmHrB;

extern int gcuLmLrGoodFit;
extern int gcuHmLrGoodFit;
extern int gcuLmHrGoodFit;
extern int gcuMmHrGoodFit;
extern int gcuHmHrGoodFit;
extern int slfLmLrGoodFit;
extern int slfHmLrGoodFit;
extern int slfLmHrGoodFit;
extern int slfMmHrGoodFit;
extern int slfHmHrGoodFit;

extern string sBestFitFile;
extern map<int,polyInfo> pC;

class DFMS_CreateGCUSLFPix0_Class {

	public:

		string sMPSTpath;
		string fitFilePath;
		double gainA, gainB;
		double zoom;

		double pCoeff[4];

		int iXl,iXr;

		linFitParams gcuP;

		prePkFitInfo pkFI;

		int numGoodPks;
		bool foundVerifPeak;

		double meanOffset;
		double meanOffsetStdDev;
		double meanOffsetA, meanOffsetB;

		double threshold;

		L2FileInfo L2Info;
		DFMS_PDS_L2_file_Class *L2Obj;

		DFMS_MPST_Class *MPSTobjIn;

		dbl2D pixG;
		double* Xin;
		double* YAin;
		double* YBin;
		double* yAFit;
		double* yBFit;
		str2D MPSTdata;
		int mptIndx;
        int mptRows;
        string commandedMass;
        peakInfo *massCal;
		double currConvConstant;
		int l3PkMaxIdA, l3PkMaxIdB;

        string slfPix0FitFileName;
        string gcuPix0FitFileName;

        DFMS_LinFit_Class *linFitA, *linFitB;
        double* offSetFitA;
        double* offSetFitB;

        vector<fitFileInfo> fitInfo;

	public:

        DFMS_CreateGCUSLFPix0_Class (string, string, double, double, dbl2D&,
        		                       DFMS_PDS_L2_file_Class *);
		~DFMS_CreateGCUSLFPix0_Class();

		void applyGainCorrection(int);
		int applyOffsetSubtraction(int);
		int calcOffset(int);
		double calcPPMDiff(double, double);
		int findBestMPSTfile(string, int, string &);
		int findMPSTpeak(double, verifPeakInfo &p, double);
		void findIonRate(int);
		int findOffsetPixels(int);
		int getMPSTdata(string, verifPeakInfo &);
		int getMPSTfilesInDir();
		void getL2HKdata(str2D &);
		int GCUpix0Calc(DFMS_PeakFit_Class *, int);
		int SLFpix0Calc(DFMS_PeakFit_Class *, int, double, L2FileInfo &,DFMS_X0FitFile_Class *);
		double peakCenterMass(L2FileInfo &, double, double, double);
		int processL2forPix0Fit(L2FileInfo &, DFMSModeInfo &, string, set<double> &);
		void calcVerifPix0FitParams(L2FileInfo &, double, double, double, double, double, int);
};

#endif /* DFMS_CREATEGCUSLFPIX0_CLASS_HH_ */
