/*
 * DFMSFindAllPeaksClass.hh
 *
 *  Created on: Aug 21, 2013
 *      Author: marinaldi
 */

#ifndef DFMS_FindAllPeaks_CLASS_HH_
#define DFMS_FindAllPeaks_CLASS_HH_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_stats.hh"

class DFMS_FindAllPeaks_Class {

	private:

		int index;
		double *count;
	    int *peakInd;
	    double *maxVal;
	    double *minVal;
	    int numPeaks;
	    int numAbsopPeaks;
	    int* absopPeaks;
	    int iXl;
	    int iXr;
	    double mean;
	    double sDevMean;

	public:

	    vector<int> peakLoc;
	    vector<double> peakVal;
	    vector<double> peakWd;
	    vector<bool> inBounds;
	    vector<bool> pkAboveThresh;
	    double maxPkVal;
	    int maxPkLoc;
	    int maxId;
	    int numGdPks;

	public:

		DFMS_FindAllPeaks_Class(double *, int, int, double, double);
		virtual ~DFMS_FindAllPeaks_Class();

   		int detectAllPeaks();
   		int findPeaksAboveThreshold(double, double);
   		double findWidth(int, double);
   		void findMaxPeak();

};

#endif /* DFMS_FindAllPeaks_CLASS_HH_ */
