/*
 * DFMS_L3Info_Class.cc
 *
 *  Created on: Oct 24, 2013
 *      Author: marinaldi
 */

#include "DFMS_L3Info_Class.hh"

//
// ---------------------- Class pksFoundInfo ------------------------
//
// Constructor/Destructor...
pksFoundInfo::pksFoundInfo(int sz) {

	num = 0;
	pkFit = 0;
	iXl = iXr = 0;
	peakLoc = new int[sz];
	peakVal = new double[sz];
	pkMass = new double[sz];
}
pksFoundInfo::~pksFoundInfo() {
	delete[] peakLoc;
	delete[] peakVal;
	delete[] pkMass;
}
void pksFoundInfo::printData(int sz) {
	cout << "pksFoundInfo::num = " << num << endl;
	cout << "pksFoundInfo::pkFit = " << pkFit << endl;
	cout << "pksFoundInfo::iXl = " << iXl << endl;
	cout << "pksFoundInfo::iXr = " << iXr << endl;

	for (int i=0; i<sz; i++) {
		cout << "pksFoundInfo::peakLoc[" << i << "] = " << peakLoc[i] << endl;
		cout << "pksFoundInfo::peakVal[" << i << "] = " << peakVal[i] << endl;
		cout << "pksFoundInfo::pkMass[" << i << "] = " << pkMass[i] << endl;
	}
}

//
// ----------------------- Class peakInfo -------------------------
//
// Constructor/Destructor...
peakInfo::peakInfo() {
    peakFoundA=0; peakFoundB=0;
    pkIDA = "Unknown"; pkIDB = "Unknown";
    peakCenterA = 0.0; peakCenterB = 0.0;
    peakCenterAUnc = 0.0; peakCenterBUnc = 0.0;
    peakHeightA = 0.0; peakHeightB = 0.0;
    peakCenterWidthA = 0.0; peakCenterWidthB = 0.0;
    peakAreaA = 0.0; peakAreaB = 0.0;
}
peakInfo::~peakInfo() {
}
void peakInfo::printData() {
	cout << "peakInfo::peakFoundA = " << peakFoundA << endl;
	cout << "peakInfo::peakFoundB = " << peakFoundB << endl;
	cout << "peakInfo::pkIDA = " << pkIDA << endl;
	cout << "peakInfo::pkIDB = " << pkIDB << endl;
	cout << "peakInfo::peakCenterA = " << peakCenterA << endl;
	cout << "peakInfo::peakCenterB = " << peakCenterB << endl;
	cout << "peakInfo::peakCenterUncA = " << peakCenterAUnc << endl;
	cout << "peakInfo::peakCenterUncB = " << peakCenterBUnc << endl;
	cout << "peakInfo::peakHeightA = " << peakHeightA << endl;
	cout << "peakInfo::peakHeightB = " << peakHeightB << endl;
	cout << "peakInfo::peakCenterWidthA = " << peakCenterWidthA << endl;
	cout << "peakInfo::peakCenterWidthB = " << peakCenterWidthB << endl;
	cout << "peakInfo::peakAreaA = " << peakAreaA << endl;
	cout << "peakInfo::peakAreaB = " << peakAreaB << endl;
}

//
// ---------------------- Class offsetInfo ----------------------
//
// Constructor/Destructor...
offsetInfo::offsetInfo() {
    offsetLevelA = 0.0; offsetLevelB = 0.0;
    offsetLevelAStdDev = 0.0; offsetLevelBStdDev = 0.0;
    bgStrtPixA = 0.0; bgStrtPixB = 0.0;
    bgStopPixA = 0.0; bgStopPixB = 0.0;
}
offsetInfo::~offsetInfo() {
}
void offsetInfo::printData() {
	cout << "offsetInfo::offsetLevelA = " << offsetLevelA << endl;
	cout << "offsetInfo::offsetLevelB = " << offsetLevelB << endl;
	cout << "offsetInfo::offsetLevelAStdDev = " << offsetLevelAStdDev << endl;
	cout << "offsetInfo::offsetLevelBStdDev = " << offsetLevelBStdDev << endl;
	cout << "offsetInfo::bgStrtPixA = " << bgStrtPixA << endl;
	cout << "offsetInfo::bgStrtPixB = " << bgStrtPixB << endl;
	cout << "offsetInfo::bgStopPixA = " << bgStopPixA << endl;
	cout << "offsetInfo::bgStopPixB = " << bgStopPixB << endl;
}

//
// ---------------------- Class verifPeakInfo ----------------------
//
// Constructor/Destructor...
verifPeakInfo::verifPeakInfo() {
	index = 0;
	peakMax = 0L;
	mass = 0.0;
	peakNameA = "Unknown";
	peakNameB = "Unknown";
	caltype = 0;
	foundA = 0; foundB = 0;
	peakCntrA = 0.0; peakCntrB = 0.0;
	peakWidthA = 0.0; peakWidthB = 0.0;
	peakHeightA = 0.0; peakHeightB = 0.0;
	ppmDiffA = 0.0; ppmDiffB = 0.0;
}
verifPeakInfo::~verifPeakInfo() {
}
void verifPeakInfo::printData() {
	cout << "verifPeakInfo::index = " << index << endl;
	cout << "verifPeakInfo::peakMax = " << peakMax << endl;
	cout << "verifPeakInfo::mass = " << mass << endl;
	cout << "verifPeakInfo::peakNameA = " << peakNameA << endl;
	cout << "verifPeakInfo::peakNameB = " << peakNameB << endl;
	cout << "verifPeakInfo::caltype = " << caltype << endl;
	cout << "verifPeakInfo::foundA = " << foundA << endl;
	cout << "verifPeakInfo::foundB = " << foundB << endl;
	cout << "verifPeakInfo::peakCntrA = " << peakCntrA << endl;
	cout << "verifPeakInfo::peakCntrB = " << peakCntrB << endl;
	cout << "verifPeakInfo::peakWidthA = " << peakWidthA << endl;
	cout << "verifPeakInfo::peakWidthB = " << peakWidthB << endl;
	cout << "verifPeakInfo::peakHeightA = " << peakHeightA << endl;
	cout << "verifPeakInfo::peakHeightB = " << peakHeightB << endl;
	cout << "verifPeakInfo::ppmDiffA = " << ppmDiffA << endl;
	cout << "verifPeakInfo::ppmDiffB = " << ppmDiffB << endl;
}

//
// ---------------------- Class calInfo ----------------------
//
// Constructor/Destructor...
calInfo::calInfo() {
	calType=0;
    pix0_A = 0.0; pix0_B = 0.0;
    GCUPix0_A = 0.0; GCUPix0_B = 0.0;
    GCUPix0_UncA = 0.0; GCUPix0_UncB = 0.0;
    selfPix0_A = 0.0; selfPix0_B = 0.0;
    selfPix0_UncA = 0.0; selfPix0_UncB = 0.0;
    GCUPix0_A_used = false; GCUPix0_B_used=false;
    selfPix0_A_used = false; selfPix0_B_used=false;
    GCUPix0_UncA_used = false; GCUPix0_UncB_used=false;
    selfPix0_UncA_used = false; selfPix0_UncB_used=false;
    m0A = 0.0; m0B = 0.0;
    pix0UncA = 0.0; pix0UncB = 0.0;
    ppmDiffA = 0.0; ppmDiffB = 0.0;
    calValueA = 0.0; calValueStdevA = 0.0;
    calValueB = 0.0; calValueStdevB = 0.0;
    calID4="None";
    calID5="None";
    calID6="None";
    upDateMPSFile = 0;
    allowNonGCUcal = 0;
}
calInfo::~calInfo() {
}
void calInfo::printData() {
	cout << "calInfo::pix0_A = " << pix0_A << endl;
	cout << "calInfo::pix0_B = " << pix0_B << endl;
	cout << "calInfo::GCUPix0_A = " << GCUPix0_A << endl;
	cout << "calInfo::GCUPix0_B = " << GCUPix0_B << endl;
	cout << "calInfo::GCUPix0_UncA = " << GCUPix0_UncA << endl;
	cout << "calInfo::GCUPix0_UncB = " << GCUPix0_UncB << endl;
	cout << "calInfo::selfPix0_A = " << selfPix0_A << endl;
	cout << "calInfo::selfPix0_B = " << selfPix0_B << endl;
	cout << "calInfo::selfPix0_UncA = " << selfPix0_UncA << endl;
	cout << "calInfo::selfPix0_UncB = " << selfPix0_UncB << endl;
	cout << "calInfo::m0A = " << m0A << endl;
	cout << "calInfo::m0B = " << m0B << endl;
	cout << "calInfo::pix0UncA = " << pix0UncA << endl;
	cout << "calInfo::pix0UncB = " << pix0UncB << endl;
	cout << "calInfo::ppmDiffA = " << ppmDiffA << endl;
	cout << "calInfo::ppmDiffB = " << ppmDiffB << endl;
	cout << "calInfo::calValueA = " << calValueA << endl;
	cout << "calInfo::calValueB = " << calValueB << endl;
	cout << "calInfo::calValueStdevA = " << calValueStdevA << endl;
	cout << "calInfo::calValueStdevB = " << calValueStdevB << endl;
	cout << "calInfo::calID4 = " << calID4 << endl;
	cout << "calInfo::calID5 = " << calID5 << endl;
	cout << "calInfo::calID6 = " << calID6 << endl;
	cout << "calInfo::upDateMPSFile = " << upDateMPSFile << endl;
	cout << "calInfo::allowNonGCUcal = " << allowNonGCUcal << endl;
}

DFMS_L3Info_Class::DFMS_L3Info_Class() {

	fitType=" ";
	isGCU=false;
    commandedMass = 0.0;
	L3FileName = " ";
	L2baseName = " ";
	calRowUsed = 0;
	numCalRows = 0;
	qualIDA = 0;
	qualIDB = 0;
	qualID = 0;
	pkHeightIonRateA = 0.0;
	pkHeightIonRateB = 0.0;
	peakAreaA = 0;
	peakAreaB = 0;
	actualPkHghtA = 0.0;
	actualPkHghtB = 0.0;
	Pix0Calc = true;
	copsPressNG = 0.0;
	copsPressRG = 0.0;
	usedAsVerifA = false;
	usedAsVerifB = false;

	// Create the L3 Info class objects
	int sz = 50;
	pkMassA = new pksFoundInfo(sz);
	pkMassB = new pksFoundInfo(sz);
	peak = new peakInfo();
	offset = new offsetInfo();
	cal = new calInfo();

}

DFMS_L3Info_Class::~DFMS_L3Info_Class() {

	//cout << "Begin delete" << endl;
	delete peak;
	delete offset;
	delete cal;
	delete pkMassA;
	delete pkMassB;
    //cout << "Completed delete" << endl;
	// TODO Auto-generated destructor stub
}

//
// ---------------------------- setvPeaksSize ----------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// allocate MPST Rows of space for the vPeaks array
//
// inputs:
//   int sz - The number of array elements to allocate
//
// returns:
//   none
// =============================================================================
// History:  Written by Mike Rinaldi, March 2014
// =============================================================================
//
void DFMS_L3Info_Class::setvPeaksSize(int sz) {

	vPeaks.reserve(sz);
	for (int i=0; i<sz; i++) {
		vPeaks.push_back(verifPeakInfo());
	}
	//cout << "Allocated " << sz << " elements for verifPeakInfo array" << endl;

}

//
//  -------------------- Print L3 Info to file ---------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// For each L2 file this method prints the important L3 info to file
//
// inputs:
//   L3Info - The info structure
//
// returns:
//   none
// =============================================================================
// History:  Written by Mike Rinaldi
// =============================================================================
//
void DFMS_L3Info_Class::printDataToFile(string dfmsEOL) {

	string na = "N/A";

	char tmp[500];
	string line = "";
	l3Log << line << dfmsEOL;
	sprintf(tmp,"---------------------------------------------------------------");
	line.assign(tmp);
	l3Log << line << dfmsEOL;
	sprintf(tmp,"--- L3Info Dump for file:  %s ----",L3FileName.c_str());
	line.assign(tmp);
	l3Log << line << dfmsEOL;
	sprintf(tmp,"---------------------------------------------------------------");
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp,"        L2 File BaseName:  %-32s",L2baseName.c_str());
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp,"        Peak Search Type:  %-32s",fitType.c_str());
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp,"          Commanded Mass:  %-8.4f",commandedMass);
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp,"        Calibration Type:  %-1.1d",cal->calType);
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp,"        Calibration ID 4:  %-27s",cal->calID4.c_str());
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp,"        Calibration ID 5:  %-27s",cal->calID5.c_str());
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp,"        Calibration ID 6:  %-27s",cal->calID6.c_str());
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp,"       Best COPS NG File:  %-27s",sBestNGCOPS.c_str());
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp,"       Best COPS RG File:  %-27s",sBestRGCOPS.c_str());
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp,"       Best COPS BG File:  %-27s",sBestBGCOPS.c_str());
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (copsPressNG != BADDATA) {
		sprintf(tmp,"      COPS Pressure (NG):  %-10.4e",copsPressNG);
	} else {
		sprintf(tmp,"      COPS Pressure (NG):  %-10s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (copsPressRG != BADDATA) {
		sprintf(tmp,"      COPS Pressure (RG):  %-10.4e",copsPressRG);
	} else {
		sprintf(tmp,"      COPS Pressure (RG):  %-10s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp,"---------------------- Row A ---------------------------------");
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp," Row A  -      Peak Name:  %-15s",peak->pkIDA.c_str());
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp," Row A  -     Peak Found:  %-1.1d",peak->peakFoundA);
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (offset->offsetLevelA != BADDATA) {
		sprintf(tmp," Row A  -         Offset:  %-10.4f",offset->offsetLevelA);
	} else {
		sprintf(tmp," Row A  -         Offset:  %-10s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->pix0_A != BADDATA) {
		sprintf(tmp," Row A  -         pixel0:  %-8.4f",cal->pix0_A);
	} else {
		sprintf(tmp," Row A  -         pixel0:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->GCUPix0_A != BADDATA) {
		sprintf(tmp," Row A  -     GCU pixel0:  %-8.4f",cal->GCUPix0_A);
	} else {
		sprintf(tmp," Row A  -     GCU pixel0:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->GCUPix0_UncA != BADDATA) {
		sprintf(tmp," Row A  - GCU pixel0 Unc:  %-8.4f",cal->GCUPix0_UncA);
	} else {
		sprintf(tmp," Row A  - GCU pixel0 Unc:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->selfPix0_A != BADDATA) {
		sprintf(tmp," Row A  -    Self pixel0:  %-8.4f",cal->selfPix0_A);
	} else {
		sprintf(tmp," Row A  -    Self pixel0:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->selfPix0_UncA != BADDATA) {
		sprintf(tmp," Row A  -  Self pix0 Unc:  %-8.4f",cal->selfPix0_UncA);
	} else {
		sprintf(tmp," Row A  -  Self pix0 Unc:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->m0A != BADDATA) {
		sprintf(tmp," Row A  -             M0:  %-8.4f",cal->m0A);
	} else {
		sprintf(tmp," Row A  -             M0:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->ppmDiffA != BADDATA) {
		sprintf(tmp," Row A  -        ppmDiff:  %-8.4f",cal->ppmDiffA);
	} else {
		sprintf(tmp," Row A  -        ppmDiff:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (qualIDA != BADDATA) {
		sprintf(tmp," Row A  -     Quality ID:  %-1.1d",qualIDA);
	} else {
		sprintf(tmp," Row A  -     Quality ID:  %-1s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (peak->peakCenterA != BADDATA) {
		sprintf(tmp," Row A -   fitPeakCenter:  %-8.4f",peak->peakCenterA);
	} else {
		sprintf(tmp," Row A -   fitPeakCenter:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (peak->peakCenterAUnc != BADDATA) {
		sprintf(tmp," Row A -  fitPeakCntrUnc:  %-8.4f",peak->peakCenterAUnc);
	} else {
		sprintf(tmp," Row A -  fitPeakCntrUnc:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (pkHeightIonRateA != BADDATA) {
		sprintf(tmp," Row A -  fitPkHght(I/s):  %-10.4e",pkHeightIonRateA);
	} else {
		sprintf(tmp," Row A -  fitPkHght(I/s):  %-10s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (peak->peakCenterWidthA != BADDATA) {
		sprintf(tmp," Row A -  fitPeakcntrWid:  %-8.4f",peak->peakCenterWidthA);
	} else {
		sprintf(tmp," Row A -  fitPeakcntrWid:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (peakAreaA != BADDATA) {
		sprintf(tmp," Row A -   peakArea(I/s):  %-10.4e",peakAreaA);
	} else {
		sprintf(tmp," Row A -   peakArea(I/s):  %-10s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (actualPkHghtA != BADDATA) {
		sprintf(tmp," Row A-actualPkHght(I/s):  %-10.4e",actualPkHghtA);
	} else {
		sprintf(tmp," Row A-actualPkHght(I/s):  %-10s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp,"---------------------- Row B - --------------------------------");
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp," Row B -       Peak Name:  %-15s",peak->pkIDB.c_str());
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp," Row B -      Peak Found:  %-1.1d",peak->peakFoundB);
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (offset->offsetLevelB != BADDATA) {
		sprintf(tmp," Row B -          Offset:  %-10.4f",offset->offsetLevelB);
	} else {
		sprintf(tmp," Row B -          Offset:  %-10s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->pix0_B != BADDATA) {
		sprintf(tmp," Row B -          pixel0:  %-8.4f",cal->pix0_B);
	} else {
		sprintf(tmp," Row B -          pixel0:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->GCUPix0_B != BADDATA) {
		sprintf(tmp," Row B -      GCU pixel0:  %-8.4f",cal->GCUPix0_B);
	} else {
		sprintf(tmp," Row B -      GCU pixel0:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->GCUPix0_UncB != BADDATA) {
		sprintf(tmp," Row B  - GCU pixel0 Unc:  %-8.4f",cal->GCUPix0_UncB);
	} else {
		sprintf(tmp," Row B  - GCU pixel0 Unc:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->selfPix0_B != BADDATA) {
		sprintf(tmp," Row B -     Self pixel0:  %-8.4f",cal->selfPix0_B);
	} else {
		sprintf(tmp," Row B -     Self pixel0:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->selfPix0_UncB != BADDATA) {
		sprintf(tmp," Row B  -  Self pix0 Unc:  %-8.4f",cal->selfPix0_UncB);
	} else {
		sprintf(tmp," Row B  -  Self pix0 Unc:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->m0B != BADDATA) {
		sprintf(tmp," Row B -              M0:  %-8.4f",cal->m0B);
	} else {
		sprintf(tmp," Row B -              M0:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (cal->ppmDiffB != BADDATA) {
		sprintf(tmp," Row B -         ppmDiff:  %-8.4f",cal->ppmDiffB);
	} else {
		sprintf(tmp," Row B -         ppmDiff:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (qualIDB != BADDATA) {
		sprintf(tmp," Row B -      Quality ID:  %-1.1d",qualIDB);
	} else {
		sprintf(tmp," Row B -      Quality ID:  %-1s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (peak->peakCenterB != BADDATA) {
		sprintf(tmp," Row B -   fitPeakCenter:  %-8.4f",peak->peakCenterB);
	} else {
		sprintf(tmp," Row B -   fitPeakCenter:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (peak->peakCenterBUnc != BADDATA) {
		sprintf(tmp," Row B -  fitPeakCntrUnc:  %-8.4f",peak->peakCenterBUnc);
	} else {
		sprintf(tmp," Row B -  fitPeakCntrUnc:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (pkHeightIonRateB != BADDATA) {
		sprintf(tmp," Row B -  fitPkHght(I/s):  %-10.4e",pkHeightIonRateB);
	} else {
		sprintf(tmp," Row B -  fitPkHght(I/s):  %-10s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (peak->peakCenterWidthB != BADDATA) {
		sprintf(tmp," Row B -  fitPeakCntrWid:  %-8.4f",peak->peakCenterWidthB);
	} else {
		sprintf(tmp," Row B -  fitPeakCntrWid:  %-8s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (peakAreaB != BADDATA) {
		sprintf(tmp," Row B -   peakArea(I/s):  %-10.4e",peakAreaB);
	} else {
		sprintf(tmp," Row B -   peakArea(I/s):  %-10s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	if (actualPkHghtB != BADDATA) {
		sprintf(tmp," Row B-actualPkHght(I/s):  %-10.4e",actualPkHghtB);
	} else {
		sprintf(tmp," Row B-actualPkHght(I/s):  %-10s",na.c_str());
	}
	line.assign(tmp);
	l3Log << line << dfmsEOL;

	sprintf(tmp,"--------------------------------------------------------------");
	line.assign(tmp);
	l3Log << line << dfmsEOL;
}

//
//  -------------------- Print L3 Info to Screen ---------------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// For each L2 file this method prints the important L3 info to screen
//
// inputs:
//   L3Info - The info structure
//
// returns:
//   none
// =============================================================================
// History:  Written by Mike Rinaldi
// =============================================================================
//
void DFMS_L3Info_Class::printDataToScreen() {

	string na = "N/A";
	bool aBad = false;

	printf("--------------------- L3Info Dump -----------------------------\n");
	printf("       L3 File Name:  %-32s\n",L3FileName.c_str());
	printf("   L2 File BaseName:  %-32s\n",L2baseName.c_str());
	printf("   Peak Search Type:  %-32s\n",fitType.c_str());
	printf("     Commanded Mass:  %-8.4f\n",commandedMass);
	printf("   Calibration Type:  %-1.1d\n",cal->calType);
	printf("   Calibration ID 4:  %-27s\n",cal->calID4.c_str());
	printf("   Calibration ID 5:  %-27s\n",cal->calID5.c_str());
	printf("   Calibration ID 6:  %-27s\n",cal->calID6.c_str());
	printf("  Best COPS NG File:  %-27s\n",sBestNGCOPS.c_str());
	printf("  Best COPS RG File:  %-27s\n",sBestRGCOPS.c_str());
	printf("  Best COPS BG File:  %-27s\n",sBestBGCOPS.c_str());
	// ---------------------------------------------------
	if (copsPressNG != BADDATA) {
		printf(" COPS Pressure (NG):  %-10.4e\n",copsPressNG);
	} else {
		printf(" COPS Pressure (NG):  %-10s\n",na.c_str());
	}
	// ---------------------------------------------------
	if (copsPressRG != BADDATA) {
		printf(" COPS Pressure (RG):  %-10.4e\n",copsPressRG);
	} else {
		printf(" COPS Pressure (RG):  %-10s\n",na.c_str());
	}
	printf("-------------------------------------------------------------------\n");
	printf("      Peak/Cal Info   Row  A            Row  B\n");
	printf("-------------------------------------------------------------------\n");
	peak->pkIDA.erase( std::remove_if( peak->pkIDA.begin(), peak->pkIDA.end(), ::isspace ), peak->pkIDA.end() );
	peak->pkIDB.erase( std::remove_if( peak->pkIDB.begin(), peak->pkIDB.end(), ::isspace ), peak->pkIDB.end() );
	printf("          Peak Name:  %-7s           %-7s\n",peak->pkIDA.c_str(),peak->pkIDB.c_str());
	string tmpA, tmpB;
	if(usedAsVerifA) {tmpA = "Yes";} else {tmpA = "No ";}
	if(usedAsVerifB) {tmpB = "Yes";} else {tmpB = "No ";}

	printf("  Verification Peak:  %-3s               %-3s\n",tmpA.c_str(),tmpB.c_str());
	printf("         Peak Found:  %-1.1d%17.17s%-1.1d \n",peak->peakFoundA," ",peak->peakFoundB);
	// ---------------------------------------------------
	if (offset->offsetLevelA != BADDATA) {
		printf("             Offset:  %-10.4e        ",offset->offsetLevelA);
	} else {
		printf("             Offset:  %-10s        ",na.c_str());
		aBad = true;
	}
	if (offset->offsetLevelB != BADDATA) {
		printf("%-10.4e\n",offset->offsetLevelB);
	} else {
		if (!aBad) {printf("%-10s\n",na.c_str()); } else {printf("  %-10s\n",na.c_str()); }
		aBad = false;
	}
	// ---------------------------------------------------
	if (cal->pix0_A != BADDATA) {
		printf("             pixel0:  %-8.4f          ",cal->pix0_A);
	} else {
		printf("             pixel0:  %-8s        ",na.c_str());
		aBad = true;
	}
	if (cal->pix0_B != BADDATA) {
		printf("%-8.4f\n",cal->pix0_B);
	} else {
		if (!aBad) {printf("%-8s\n",na.c_str()); } else {printf("  %-8s\n",na.c_str()); }
		aBad = false;
	}
	// ---------------------------------------------------
	if (cal->GCUPix0_A != BADDATA) {
		printf("         GCU pixel0:  %-8.4f          ",cal->GCUPix0_A);
	} else {
		printf("         GCU pixel0:  %-8s        ",na.c_str());
		aBad = true;
	}
	if (cal->GCUPix0_B != BADDATA) {
		printf("%-8.4f\n",cal->GCUPix0_B);
	} else {
		if (!aBad) {printf("%-8s\n",na.c_str()); } else {printf("  %-8s\n",na.c_str()); }
		aBad = false;
	}
	if (cal->GCUPix0_UncA != BADDATA) {
			printf("     GCU pixel0 Unc:  %-8.4f          ",cal->GCUPix0_UncA);
		} else {
			printf("     GCU pixel0 Unc:  %-8s        ",na.c_str());
			aBad = true;
	}
	if (cal->GCUPix0_UncB != BADDATA) {
		printf("%-8.4f\n",cal->GCUPix0_UncB);
	} else {
		if (!aBad) {printf("%-8s\n",na.c_str()); } else {printf("  %-8s\n",na.c_str()); }
		aBad = false;
	}
	// ---------------------------------------------------
	if (cal->selfPix0_A != BADDATA) {
		printf("        Self pixel0:  %-8.4f          ",cal->selfPix0_A);
	} else {
		printf("        Self pixel0:  %-8s        ",na.c_str());
		aBad = true;
	}
	if (cal->selfPix0_B != BADDATA) {
		printf("%-8.4f\n",cal->selfPix0_B);
	} else {
		if (!aBad) {printf("%-8s\n",na.c_str()); } else {printf("  %-8s\n",na.c_str()); }
		aBad = false;
	}
	if (cal->selfPix0_UncA != BADDATA) {
		printf("    Self pixel0 Unc:  %-8.4f          ",cal->selfPix0_UncA);
	} else {
		printf("    Self pixel0 Unc:  %-8s        ",na.c_str());
		aBad = true;
	}
	if (cal->selfPix0_UncB != BADDATA) {
		printf("%-8.4f\n",cal->selfPix0_UncB);
	} else {
		if (!aBad) {printf("%-8s\n",na.c_str()); } else {printf("  %-8s\n",na.c_str()); }
		aBad = false;
	}
	// ---------------------------------------------------
	if (cal->m0A != BADDATA && cal->m0B != BADDATA) {
		printf("       Pix0 Mass M0:  %-8.4f          %-8.4f\n",cal->m0A,cal->m0B);
	} else {
		printf("       Pix0 Mass M0:  %-8s          %-8s\n",na.c_str(),na.c_str());
	}
	// ---------------------------------------------------
	if (cal->ppmDiffA != BADDATA) {
		printf("            ppmDiff:  %-10.4f        ",cal->ppmDiffA);
	} else {
		printf("            ppmDiff:  %-8s        ",na.c_str());
		aBad = true;
	}
	if (cal->ppmDiffB != BADDATA) {
		if (cal->ppmDiffA == BADDATA) {
			printf("  %-10.4f\n",cal->ppmDiffB);
		} else {
			printf("%-10.4f\n",cal->ppmDiffB);
		}
	} else {
		if (!aBad) {printf("%-8s\n",na.c_str()); } else {printf("  %-8s\n",na.c_str()); }
		aBad = false;
	}
	// ---------------------------------------------------
	printf("         Quality ID:  %-1.1d%17.17s%-1.1d\n",qualIDA," ",qualIDB);
	// ---------------------------------------------------
	if (peak->peakCenterA != BADDATA) {
		printf(" Fitted Peak Center:  %-8.4f          ",peak->peakCenterA);
	} else {
		printf(" Fitted Peak Center:  %-8s        ",na.c_str());
		aBad = true;
	}
	if (peak->peakCenterB != BADDATA) {
		if (peak->peakCenterA == BADDATA) {
			printf("  %-8.4f\n",peak->peakCenterB);
		} else {
			printf("%-8.4f\n",peak->peakCenterB);
		}
	} else {
		if (!aBad) {printf("%-8s\n",na.c_str()); } else {printf("  %-8s\n",na.c_str()); }
		aBad = false;
	}
	// ---------------------------------------------------
	if (pkHeightIonRateA != BADDATA) {
		printf(" Fitted PkHght(I/s):  %-10.4e        ",pkHeightIonRateA);
	} else {
		printf(" Fitted PkHght(I/s):  %-8s        ",na.c_str());
		aBad = true;
	}
	if (pkHeightIonRateB != BADDATA) {
		if (pkHeightIonRateA == BADDATA) {
			printf("  %-10.4e\n",pkHeightIonRateB);
		} else {
			printf("%-10.4e\n",pkHeightIonRateB);
		}
	} else {
		if (!aBad) {printf("%-8s\n",na.c_str()); } else {printf("  %-8s\n",na.c_str()); }
		aBad = false;
	}
	// ---------------------------------------------------
	if (peak->peakCenterWidthA != BADDATA) {
		printf(" Fitted PeakCntrWid:  %-8.4f          ",peak->peakCenterWidthA);
	} else {
		printf(" Fitted PeakCntrWid:  %-8s        ",na.c_str());
		aBad = true;
	}
	if (peak->peakCenterWidthB != BADDATA) {
		if (peak->peakCenterWidthA == BADDATA) {
			printf("  %-8.4f\n",peak->peakCenterWidthB);
		} else {
			printf("%-8.4f\n",peak->peakCenterWidthB);
		}
	} else {
		if (!aBad) {printf("%-8s\n",na.c_str()); } else {printf("  %-8s\n",na.c_str()); }
		aBad = false;
	}
	// ---------------------------------------------------
	if (peakAreaA != BADDATA) {
		printf(" Fitted PkArea(I/s):  %-10.4e        ",peakAreaA);
	} else {
		printf(" Fitted PkArea(I/s):  %-8s        ",na.c_str());
		aBad = true;
	}
	if (peakAreaB != BADDATA) {
		if (peakAreaA == BADDATA) {
			printf("  %-10.4e\n",peakAreaB);
		} else {
			printf("%-10.4e\n",peakAreaB);
		}
	} else {
		if (!aBad) {printf("%-8s\n",na.c_str()); } else {printf("  %-8s\n",na.c_str()); }
		aBad = false;
	}
	// ---------------------------------------------------
	if (actualPkHghtA != BADDATA) {
		printf(" Actual PkHght(I/s):  %-10.4e        ",actualPkHghtA);
	} else {
		printf(" Actual PkHght(I/s):  %-8s        ",na.c_str());
		aBad = true;
	}
	if (actualPkHghtB != BADDATA) {
		if (actualPkHghtA == BADDATA) {
			printf("  %-10.4e\n",actualPkHghtB);
		} else {
			printf("%-10.4e\n",actualPkHghtB);
		}
	} else {
		if (!aBad) {printf("%-8s\n",na.c_str()); } else {printf("  %-8s\n",na.c_str()); }
		aBad = false;
	}
	printf("-------------------------------------------------------------------\n");

	/*
	printf(" ------------- Peak Masses Found within the Bounds ----------------\n");
	printf(" ------------ leftPixel:  %3.3d  and rightPixel:  %3.3d ---------------\n",pkMassA.iXl,pkMassA.iXr);
	printf(" --------------------------- Row A --------------------------------\n");
	printf(" pkLoc      pkHght           Mass\n");
	if (pkMassA.num > 50) pkMassA.num = 50;
	if (pkMassA.num == 0) printf("\n--- Peak Finding or Fitting Error -----\n\n");
    for (int i=0; i<pkMassA.num; i++) {
    	if (pkMassA.peakLoc[i] == pkMassA.pkFit) {
    		printf(" %-3.3d        %-13.4f  %-10.6f -- Largest Peak within Bounds \n",
    				pkMassA.peakLoc[i],pkMassA.peakVal[i],pkMassA.pkMass[i]);
    	} else {
    		printf(" %-3.3d        %-13.4f  %-10.6f\n",pkMassA.peakLoc[i],
    								pkMassA.peakVal[i], pkMassA.pkMass[i]);
    	}
    }
	printf(" --------------------------- Row B --------------------------------\n");
	printf(" pkLoc      pkHght           Mass\n");
	if (pkMassB.num > 50) pkMassB.num = 50;
	if (pkMassB.num == 0) printf("\n--- Peak Finding or fitting Error -----\n\n");
    for (int i=0; i<pkMassB.num; i++) {
    	if (pkMassB.peakLoc[i] == pkMassB.pkFit) {
    		printf(" %-3.3d        %-13.4f  %-10.6f -- Largest Peak within Bounds \n",
    				pkMassB.peakLoc[i],pkMassB.peakVal[i],pkMassB.pkMass[i]);
    	} else {
    		printf(" %-3.3d        %-13.4f  %-10.6f\n",pkMassB.peakLoc[i],
    								pkMassB.peakVal[i], pkMassB.pkMass[i]);
    	}
    }
	printf("-------------------------------------------------------------------\n");
   */

}

