/*
 * DFMS_L3Info_Class.hh
 *
 *  Created on: Oct 24, 2013
 *      Author: marinaldi
 */

#ifndef DFMS_L3INFO_CLASS_HH_
#define DFMS_L3INFO_CLASS_HH_

#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include <algorithm>

using namespace std;

extern fstream l3Log;
extern double BADDATA;
extern string sBestNGCOPS;
extern string sBestRGCOPS;
extern string sBestBGCOPS;

// Define the various classes used by the L3Info class

// used by preliminary peaks found code
class pksFoundInfo {

	public:
		int num;
		int pkFit;
		int iXl;
		int iXr;
		int *peakLoc;
		double *peakVal;
		double *pkMass;

		pksFoundInfo(int);
		~pksFoundInfo();
		void printData(int);

};


// Information pertaining to the peak used to make the fit
class peakInfo {

	public:
		int peakFoundA, peakFoundB;
		string pkIDA, pkIDB;
		double peakCenterA, peakCenterB;
		double peakCenterAUnc, peakCenterBUnc;
		double peakHeightA, peakHeightB;
		double peakCenterWidthA, peakCenterWidthB;
		double peakAreaA, peakAreaB;

		peakInfo();
		~peakInfo();
		void printData();

};

// Offset related info
class offsetInfo {

	public:
		double offsetLevelA,offsetLevelB;
		double offsetLevelAStdDev, offsetLevelBStdDev;
		double bgStrtPixA, bgStrtPixB;
		double bgStopPixA, bgStopPixB;

		offsetInfo();
		~offsetInfo();
		void printData();

};

// verification peak related info
class verifPeakInfo {

	public:
		int index;
		double mass;
		long peakMax;
		string peakNameA, peakNameB;
		int caltype;
		int foundA,foundB;
		double peakCntrA,peakCntrB;
		double peakWidthA,peakWidthB;
		double peakHeightA,peakHeightB;
		double ppmDiffA,ppmDiffB;

		verifPeakInfo();
		~verifPeakInfo();
		void printData();

};

// Calibration related info
class calInfo {

	public:
		double pix0_A,pix0_B;
	    double GCUPix0_A,GCUPix0_B;
	    double GCUPix0_UncA,GCUPix0_UncB;
	    double selfPix0_A,selfPix0_B;
	    double selfPix0_UncA,selfPix0_UncB;
	    bool GCUPix0_A_used, GCUPix0_B_used;
	    bool selfPix0_A_used, selfPix0_B_used;
	    bool GCUPix0_UncA_used, GCUPix0_UncB_used;
	    bool selfPix0_UncA_used, selfPix0_UncB_used;
	    double m0A, m0B;
	    double pix0UncA, pix0UncB;
	    double ppmDiffA, ppmDiffB;
	    double calValueA, calValueStdevA;
	    double calValueB, calValueStdevB;
	    int calType;
	    string calID4;
	    string calID5;
	    string calID6;
	    int upDateMPSFile;
	    int allowNonGCUcal;

	    calInfo();
	    ~calInfo();
	    void printData();

};

//
// ------------------ Define the class -----------------------
//
class DFMS_L3Info_Class {

public:
	string fitType;
	bool isGCU;
	bool usedAsVerifA,usedAsVerifB;
	double commandedMass;
	string L3FileName;
	string L2baseName;
	int calRowUsed;
	int numCalRows;
	int qualIDA;
	int qualIDB;
	int qualID;
	double pkHeightIonRateA, pkHeightIonRateB;
    double actualPkHghtA, actualPkHghtB;
    double peakAreaA, peakAreaB;
	double copsPressNG, copsPressRG;
	bool Pix0Calc;

	peakInfo *peak;
	offsetInfo *offset;
	calInfo *cal;
	vector<verifPeakInfo> vPeaks;
	pksFoundInfo *pkMassA;
	pksFoundInfo *pkMassB;

	void setvPeaksSize(int);

public:
	DFMS_L3Info_Class();
	virtual ~DFMS_L3Info_Class();

	void printDataToFile(string);
	void printDataToScreen();

};

#endif /* DFMS_L3INFO_CLASS_HH_ */
