/*
 * DFMS_LinFit_Class.hh
 *
 *  Created on: Jul 31, 2013
 *      Author: marinaldi
 */

#ifndef DFMS_LINFIT_CLASS_HH_
#define DFMS_LINFIT_CLASS_HH_

#include <cmath>
#include "DFMS_globals.hh"
#include "DFMS_structs.hh"
#include <cfloat>

using namespace std;

// Vectors holding GCU,Pix0 mass tables for fitting purposes
extern vector<x0FitInfo> gcuLmLrA, gcuHmLrA, gcuLmLrB, gcuHmLrB;
extern vector<x0FitInfo> gcuLmHrA, gcuMmHrA, gcuHmHrA, gcuLmHrB, gcuMmHrB, gcuHmHrB;
// Vectors holding SLF,Pix0 mass tables for fitting purposes
extern vector<x0FitInfo> slfLmLrA, slfHmLrA, slfLmLrB, slfHmLrB;
extern vector<x0FitInfo> slfLmHrA, slfMmHrA, slfHmHrA, slfLmHrB, slfMmHrB, slfHmHrB;

// Double precision limit.  Should be defined in float.h but is not seen by eclipse
#define DBL_EPSILON 	2.2204460492503131e-16

using namespace std;

/*
class Point2D {
    public:
        Point2D(double X = 0.0, double Y = 0.0) : x(X), y(Y) { }

        void setPoint(double X, double Y) { x = X; y = Y; }
        void setX(double X) { x = X; }
        void setY(double Y) { y = Y; }

        double getX() const { return x; }
        double getY() const { return y; }

    private:
        double x, y;
};
*/
class DFMS_LinFit_Class {

	friend ostream& operator<<(ostream& out, DFMS_LinFit_Class& lr);

	protected:
		long n;             // number of data points input so far
		double sumX, sumY;  // sums of x and y
		double sumXsquared, // sum of x squares
			   sumYsquared; // sum y squares
		double sumXY;       // sum of x*y

		double a, b;        // coefficients of f(x) = a + b*x
		double coefD,       // coefficient of determination
          	   coefC,       // coefficient of correlation
               stdError;    // standard error of estimate

		double Syox,
			   Sa, 			// Error on paramter a
			   Sb;			// Error on paramter b

	public:
		virtual ~DFMS_LinFit_Class();
		DFMS_LinFit_Class();
		//DFMS_LinFit_Class(Point2D *p, long size);
		DFMS_LinFit_Class(double *x, double *y, long size, int);

		virtual double geta() const { return a; }
		virtual double getb() const { return b; }
		virtual double getSerror() const { return stdError; }
		virtual double getCoefD() const { return coefD; }
		virtual double getCoefC() const { return coefC; }
		virtual double getSa() const { return Sa; }
		virtual double getSb() const { return Sb; }
		virtual double getSigEst() const {return Syox; }

		virtual void addXY(const double& x, const double& y, int);
		virtual void startFit(long s, string, string, string, int);
		virtual double findOffSet(long s, double, string, string, string, int);
		double avgPix0(string, string, string, int);
		void errors(string, string, string, int);

		//void addPoint(const Point2D& p) { addXY(p.getX(), p.getY()); }

		// Must have at least 3 points to calculate
		// standard error of estimate.  Do we have enough data?
		int haveData(int);  // const { return (n > 2 ? 1 : 0); }
		//long items() const { return n; }

		//virtual double estimateY(double x) const { return (a + b * x); }

        void Calculate(int);   // calculate coefficients

};

#endif /* DFMS_LINFIT_CLASS_HH_ */
