
#ifndef DFMS_PDS_L2_FILE_CLASS_H_
#define DFMS_PDS_L2_FILE_CLASS_H_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_PDS_file_Class.hh"

//
// This Class represents the relevant data and methods that act on an L2 file
//
class DFMS_PDS_L2_file_Class: public DFMS_PDS_file_Class {

	// Data
     private:
		string path;
		string fileName;
		string L2File;
		string fileDate;
		int HKrows;
		int HKcols;
		int dataRows;
		int dataCols;

	// Data obj
	public:
		mapstr HKobj;
		mapstr DataObj;
		str2D HKdata;
		int2D L2Data;
          
	public:
		// Generic Methods
		DFMS_PDS_L2_file_Class(string p, string f);
		~DFMS_PDS_L2_file_Class();
		int getHKrows() {return HKrows;}
		int getDataRows() {return dataRows;}
		int getDataCols() {return dataCols;}
		int getModeID();
		string getStrModeID();
		string getFileDate();
		string getFileName() {return fileName;}
		string getL2FullPathName() {return L2File;}
		mapstr getPDSheader() {return PDSheader;}
		void printL2File(string);
		int DumpL2toFile(string);
		string getHKdataVal(string, int);

		// Methods to read L2 Features
		int readHKdata(fstream &);
		int readL2data(fstream &);

		// Method to input an L2 file 
		int getL2file(L2FileInfo &);

};

#endif //DFMS_PDS_L2_FILE_CLASS_H_
