
#ifndef DFMS_PDS_L3_FILE_CLASS_H_
#define DFMS_PDS_L3_FILE_CLASS_H_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_PDS_file_Class.hh"

extern int iPltFile;
extern string sPlotFilePath;
extern string sGNUplotPath;
extern map<int,polyInfo> pC;

//
// This Class represents the relevant data and methods that act on an L3 file
//
class DFMS_PDS_L3_file_Class: public DFMS_PDS_file_Class {

	// Data
     private:
		string path;
		string fileName;
		string L3File;
		string fileDate;
		int HKrows;
		int CalRows;

	// Data
	public:
		mapstr HKobj;
		mapstr CalObj;
		mapstr L3DataObj;
		str2D  L3HKdata;
		str2D  CalData;
		dbl2D  L3Data;
		L2FileInfo L2Info;
          
	// Generic Methods
	public:
		DFMS_PDS_L3_file_Class(string, string, int, int, mapstr &,
						   str2D &, str2D &, dbl2D &, L2FileInfo &);
		~DFMS_PDS_L3_file_Class();
		string getFileName() {return fileName;}
		string getL3FileName() {return L3File;}
		string getFileDate() {return fileDate;}

	// Methods that build L3 output Features
	public:
		void initializeData(str2D &, str2D &, dbl2D &);
		int formHKobj();
		int formCalObj();
		int formL3DataObj();

	// Methods that Write the L3 Featuers
	public:
		//int writePDSheader(fstream &);
		int writeOldPDSheader(fstream &);
		int writeNewPDSheader(fstream &);
		int writeHKdata(fstream &);
		int writeCalData(fstream &);
		int writeL3data(fstream &);

	// Method to process an L3 File features for output
	public:
		int createL3File();

	// Method to print Class Data
	public:
		void printL3File(string);
		int DumpL3toFile(string);
		int quickPlotL3Data(string, string, string, string);

};

#endif //DFMS_PDS_L3_FILE_CLASS_H_

