
#ifndef DFMS_PIXELGAIN_TABLE_CLASS_H_
#define DFMS_PIXELGAIN_TABLE_CLASS_H_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_PDS_file_Class.hh"

extern string sInstrumentModel;

//
// This class represents the relevant data and methods that act on a Pixel Gain Table file
//
class DFMS_PixelGain_Table_Class: public DFMS_PDS_file_Class {

     private:
		string path;
		string fileName;
		int TableRows;
		int cols;

	public:
		map<string,string> pixGTobj;
		dbl2D pixGTdata;

	public:
		DFMS_PixelGain_Table_Class();
		DFMS_PixelGain_Table_Class(string p, string f);
		~DFMS_PixelGain_Table_Class();
		int getTableRows() {return TableRows;}

		int readpixGTdata(fstream &, int &);
		string getFileName() {return fileName;}
		void printpixGTtable(string);
		int getPGTable(string, string);

		static int getPGTtimeInDir(string, vector<DirInfo> &);
		static int getPGTFileInfo(string sPGTpath,vector<pgFileInfo> &);
		static int findBestPGTtime(string, string, int, int *, string &, string &, vector<pgFileInfo> &);
};

#endif  //DFMS_PIXELGAIN_TABLE_CLASS_H_


#define HEIGHT 5
#define WIDTH 3
#define DEPTH 7

/*
int main() {
  double ***p2DArray;

  // Allocate memory
  p2DArray = new double**[HEIGHT];
  for (int i = 0; i < HEIGHT; ++i) {
    p2DArray[i] = new double*[WIDTH];

    for (int j = 0; j < WIDTH; ++j)
      p2DArray[i][j] = new double[DEPTH];
  }

  // Assign values
  p2DArray[0][0][0] = 3.6;
  p2DArray[1][2][4] = 4.0;

  // De-Allocate memory to prevent memory leak
  for (int i = 0; i < HEIGHT; ++i) {
    for (int j = 0; j < WIDTH; ++j)
      delete [] p2DArray[i][j];

    delete [] p2DArray[i];
  }
  delete [] p2DArray;

  return 0;

}
*/
