/*
 * DFMS_ProcessCEM_Class.hh
 *
 *  Created on: Apr 25, 2016
 *      Author: marinaldi
 */

#ifndef SRC_DFMS_PROCESSCEM_CLASS_HH_
#define SRC_DFMS_PROCESSCEM_CLASS_HH_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_PDS_L2_file_Class.hh"
#include "DFMS_COPS_Class.hh"

class DFMS_ProcessCEM_Class {

	// Data
     private:
		string L2fileName, L3fileName;
		string L3path, L3File;
		string L2fileDate, L3fileDate;
		int L3HKrows;

	// Data obj
	public:
		mapstr L3HKobj;
		mapstr L3DataObj;
		str2D L3HKdata;
		dbl2D L3Data;
		int L3DataRows;

		str2D L2HKdata;

		double resPS;
		double step0;
		double *mass;
		double commMass;

		DFMS_PDS_L2_file_Class *L2Obj;
		DFMS_COPS_Class *COPSobjIn;
		string sCOPSpath;
		double copsPressNG, copsPressBG, copsPressRG;

	public:
		// Generic Methods
		DFMS_ProcessCEM_Class(string, string, string, DFMS_PDS_L2_file_Class *);
		virtual ~DFMS_ProcessCEM_Class();

	// CEM specific methods
		int processL2(L2FileInfo &);
		double getResPerStep(L2FileInfo &);
		double getStep0(const L2FileInfo &);
		double getSignalScale(const L2FileInfo &);
		double getMassScale(double);

	// Level 3 related output methods

		// Methods to initialize and form L3 objects
		void initializeData();
		int openFile(string,fstream &);
		void closeFile(fstream &);
		int writeObj(fstream &, mapstr &, int);
		int formHKobj();
		int formL3DataObj();

		// Methods to form/write L3 objects
		int writeOldPDSheader(fstream &);
		int writeNewPDSheader(fstream &);
		void getL2HKdata();
		void addPolyOffCoeffInfo(int, int *);
		void formL3HKdata(const L2FileInfo &);
		int writeHKdata(fstream &);
		int writeL3data(fstream &);

		// Method to process a CEM L3 File features for output
		int createL3File();

		// Methods to print L3 Data
		void printL3File(string);
		int DumpL3toFile(string);

		void addCOPSinfo();

};

#endif /* SRC_DFMS_PROCESSCEM_CLASS_HH_ */
