/*
 * DFMS_X0FitFile_Class.hh
 *
 *  Created on: Jul 1, 2014
 *      Author: marinaldi
 */

#ifndef DFMS_X0FITFILE_CLASS_HH_
#define DFMS_X0FITFILE_CLASS_HH_

#include "DFMS_globals.hh"
#include "DFMS_utility.hh"
#include "DFMS_structs.hh"
#include "DFMS_PDS_file_Class.hh"
#include "DFMS_LinFit_Class.hh"
#include "DFMS_speciesTable.hh"

#include <numeric>

extern string sx0FitsDataPath;
extern string sBestFitFile;

// Vectors holding GCU,Pix0 mass tables for fitting purposes
extern vector<x0FitInfo> gcuLmLrA, gcuHmLrA, gcuLmLrB, gcuHmLrB;
extern vector<x0FitInfo> gcuLmHrA, gcuMmHrA, gcuHmHrA, gcuLmHrB, gcuMmHrB, gcuHmHrB;
// Vectors holding SLF,Pix0 mass tables for fitting purposes
extern vector<x0FitInfo> slfLmLrA, slfHmLrA, slfLmLrB, slfHmLrB;
extern vector<x0FitInfo> slfLmHrA, slfMmHrA, slfHmHrA, slfLmHrB, slfMmHrB, slfHmHrB;

//
// This Class represents the relevant data and methods that act
// on an X0Fit File
//
class DFMS_X0FitFile_Class: public DFMS_PDS_file_Class {

	// Data
	private:
		string path;
		string fileName;
		string pix0FitFile;
		string fileDate;
		int fitRowsA, fitRowsB;
		int fitCols;
		int pixFitRows;
		string type;
		string massType;

	// Data
	public:
		int qualID;
		mapstr fitObjA, fitObjB;
		mapstr fitResDataObj;
		str2D  fitDataA, fitDataB;
		double fitResData[8];

		double aA, bA, aB, bB;
		double sErrorA, sErrorB;
		double RcoeffA, RcoeffB;
		double R2coeffA, R2coeffB;
		double errOnaA, errOnbA;
		double errOnaB, errOnbB;

		mapstr L2header;

	// Generic Methods
	public:
		DFMS_X0FitFile_Class(string);					 // Constructor for Reading
		DFMS_X0FitFile_Class(string, string, int, int);  // constructor for Writing
		virtual ~DFMS_X0FitFile_Class();
		string getFileName();
		string getFileDate() {return fileDate;}

	public:
		// Methods to read pix0Fit files
		int readPix0FitFile(int, string, string, string, string, vector<fitFileInfo> &);
		int readFitData(fstream &);
		int readFitResData(fstream &);
		static int getFitFilesInDir(string, vector<fitFileInfo> &);
		static int findBestFitFile(string, string, string, string, string, vector<fitFileInfo> &);

	// Methods that build pix0 Fit output
	public:
		//int formPDSheader();
		int formFitObj(int, int);
		int formFitResDataObj();

	// Method to write a pix0Fit File
	public:
		int writePix0FitFile(string, string, string, string);
		int writePDSheader(fstream &, string);
		int writeFitData(fstream &, string, string, string);
		int writeFitResData(fstream &);
		int getL2header(string p, string f);

	// Method to process a pix0Fit File
	public:
		void calcGCUPix0FitParams(int, double, double, L2FileInfo &);
		void calcVerifPix0FitParams(int, double, double, L2FileInfo &);
		int doTheLinFit(string, string, string, linFitParams &);
		double determineA(double, double, double);
		double determinePix0(double, double, double);
		int uniqCommMasses(string, string, string, int, double*);
		double getPix0Unc(int, double);

		// Vectors holding GCU and SLF file Info
		vector<fitFileInfo> gcuLmFiles,gcuHmFiles;
		vector<fitFileInfo> slfLmFiles,slfHmFiles;

	// Print all obj and data
	public:
		void printPix0File(string);

};

#endif /* DFMS_X0FITFILE_CLASS_HH_ */
