/*
 * DFMS_definedConstants.hh
 *
 *  Created on: Jul 14, 2014
 *      Author: marinaldi
 */

#ifndef DFMS_DEFINEDCONSTANTS_HH_
#define DFMS_DEFINEDCONSTANTS_HH_

// Check for OS type and set parameter
#ifdef _WIN32
	#define OSTYPE "Windows"
#elif __APPLE__
	#define OSTYPE "MacOSX"
#elif __linux__
	#define OSTYPE "Linux"
#elif __CYGWIN__
	#define OSTYPE "Cygwin"
#elif __unix__
	#define OSTYPE "Unix"
#elif defined(_POSIX_VERSION)
	#define OSTYPE "POSIX"
#else
	# error "Operating System undefined"
#endif

#define QLPPAGE			   50			// Number of items to show on each QuickLook section. (In between headers)

#define NUMREQHK		   	10			// Number of PDS and HK items to read into L2Info.
										// This is associated with array <mtitle>

#define NUMSPECIALMASSES   128			// Number of masses used for time series
										// This is associated with array <spMasses>

#define NUMSLFPKMASSES		31			// Number of SLF peak and/or commanded masses
										// This is associated with array <slfMasses>

#define L3HKROWS			39			// Number of KouseKeeping Rows in an L3 file

#define HISTONUMBINS 	   100			// The number of histogram bins used in fit initialization

#define NUMPIX             512          // The number of pixels on the DFMS MCP

#define MAXITERS 		   200          // Max number of iterations used by the non-linear fit code

#define FITPARAMS            3			// The number of fit parameters used for the Gaussian fit

#define MAXNUMPEAKS         20          // The maximum number of peaks that can be found by the peak finding algorithm

#define JULIANYEAR      31557600.00002883   // 1 Julian year in seconds

#define DUMPPGINTP 			 0          // Set to 1 to dump Pixel Gain interpolation versus Data files. 0 to not dump

#endif /* DFMS_DEFINEDCONSTANTS_HH_ */
