#include "DFMS_readExclusionFile.hh"

/* ------------------------ Read DFMS Date/Time Exclusion File  ---------------------------*/

int DFMS_readExclusionFile() {

	string sFunctionName="DFMS_readExclusionFile";

	excludeInfo ex;

	ifstream efile;
	char input[200];
	string line, comLine, str;
	vector<string> tokens;

	// Open the DFMS exclusionFile file for reading
	efile.open((sInstallDir+exclusionFile).c_str());
	if(!efile.is_open()) {
		sErrorMessage="Error opening DFMS Exclusion Dates File: "+exclusionFile;
		writeToLog(sErrorMessage, sFunctionName, ERROR);
		return 0;
	}

	// Read in a line at a time and process info into struct vector
	 	while (true) {
	 		efile.getline(input,200);
	 		if (efile.eof()) break;
			line.assign(input);
			comLine = line.substr(0,1);
			if (comLine != "#") {
				util_splitString(line, ',', tokens);
				//cout << tokens[0] << " " << tokens[1] << " " << tokens[2] << " " << endl;
				ex.sStart = util_trim(tokens[0]);
				ex.sEnd = util_trim(tokens[1]);
				ex.comment = util_trim(tokens[2]);
				ex.dStart = rosToSec(ex.sStart,1);
				ex.dEnd = rosToSec(ex.sEnd,1);
				//ex.print();
				tokens.clear();
				dateExclusion.push_back(ex);
			}
		}
		efile.close();
    
    return 1;

}
