//
//  DFMS_readPeakExclusionFiles.cc
//  DFMSL2toL3
//
//  Created by Michael Rinaldi on 9/1/18.
//  Copyright © 2018 Michael Rinaldi. All rights reserved.
//

#include "DFMS_readPeakExclusionFiles.hh"

/* ------------------------ Read DFMS Peak Exclusion File  ---------------------------*/

int DFMS_readPeakExclusionFiles() {
    
    string sFunctionName="DFMS_readPeakExclusionFiles";
    
    pair<int,int> p;
    vector<pair<int,int> > vec;
    
    ifstream efile;
    char input[200];
    string line, comLine, str;
    vector<string> tokens;
    
    // Open the DFMS exclusionFile1 file for reading
    efile.open((sInstallDir+sPeakExclusionFile1).c_str());
    if(!efile.is_open()) {
        sErrorMessage="Error opening DFMS Peak Exclusion File: "+sPeakExclusionFile1;
        writeToLog(sErrorMessage, sFunctionName, ERROR);
        return 0;
    }
    
    // Read in a line at a time and process info into struct vector
    while (true) {
        efile.getline(input,200);
        if (efile.eof()) break;
        line.assign(input);
        comLine = line.substr(0,1);
        if (comLine != "#") {
            util_splitString(line, ',', tokens);
            //cout << tokens[0] << " " << tokens[1] << " " << tokens[2] << " " << endl;
            
            int mass = util_stringToInt(util_trim(tokens[0]));
            // create peak boundary pairs
            int k=1;
            for(int i=1; i<11; i++) {
                p = make_pair(util_stringToInt(util_trim(tokens[k])),util_stringToInt(util_trim(tokens[k+1])));
                vec.push_back(p);
                k+=2;
            }
            peaksToExclude1[mass] = vec;
            
            //ex.print();
            vec.clear();
            tokens.clear();
        }
    }
    
    efile.close();
    
    // Open the DFMS exclusionFile2 file for reading
    efile.open((sInstallDir+sPeakExclusionFile2).c_str());
    if(!efile.is_open()) {
        sErrorMessage="Error opening DFMS Peak Exclusion File: "+sPeakExclusionFile2;
        writeToLog(sErrorMessage, sFunctionName, ERROR);
        return 0;
    }
    
    // Read in a line at a time and process info into struct vector
    while (true) {
        efile.getline(input,200);
        if (efile.eof()) break;
        line.assign(input);
        comLine = line.substr(0,1);
        if (comLine != "#") {
            util_splitString(line, ',', tokens);
            //cout << tokens[0] << " " << tokens[1] << " " << tokens[2] << " " << endl;
            
            int mass = util_stringToInt(util_trim(tokens[0]));
            // create peak boundary pairs
            int k=1;
            for(int i=1; i<11; i++) {
                //p = make_pair(util_stringToInt(util_trim(tokens[k++])),util_stringToInt(util_trim(tokens[k++])));
                p = make_pair(util_stringToInt(util_trim(tokens[k])),util_stringToInt(util_trim(tokens[k+1])));
                vec.push_back(p);
                k+=2;
            }
            peaksToExclude2[mass] = vec;
            
            //ex.print();
            vec.clear();
            tokens.clear();
        }
    }
    
    efile.close();
    
    return 1;
    
}
