/*
 * DFMS_speciesTable.cc
 *
 *  Created on: Jul 24, 2014
 *      Author: marinaldi
 */

#include "DFMS_speciesTable.hh"
//
// ----------------------- DFMS_speciesTable ------------------------
//
// =============================================================================
// Routine Description
// =============================================================================
// This function creates a map object containing all species from commanded mass 13
// to 140.  It list the actual mass and isotopic masses, and the species name.
// inputs:
// returns:
//   None
// =============================================================================
// History: Written by Mike Rinaldi, July 2014
// =============================================================================
//
void DFMS_speciesTable() {

	spcInfo sp;

	sp.name = "CH";
	sp.kmass0 = 13.00727645;
	speciesDef.insert(pair<double, spcInfo>(13, sp));					// From nonGCU Mass Peak Search Table
	sp.reset();

	sp.name = "N";
	sp.kmass0 = 14.00252542;
	speciesDef.insert(pair<double, spcInfo>(14, sp));

	sp.name = "CH3";
	sp.kmass0 = 15.02292652;
	speciesDef.insert(pair<double, spcInfo>(15, sp));
	sp.reset();

	sp.name = "CH3";
	sp.kmass0 = 15.02292652;
	speciesDef.insert(pair<double, spcInfo>(15.01, sp));
	sp.reset();

	sp.name = "^16O";
	sp.kmass0 = 15.99436605;
	speciesDef.insert(pair<double, spcInfo>(16, sp));					// From GCU Mass Peak Search Table
	sp.reset();

	sp.name = "^16O";
	sp.kmass0 = 15.99436605;
	speciesDef.insert(pair<double, spcInfo>(16.51, sp));				// From GCU Mass Peak Search Table
	sp.reset();

	sp.name = "OH";
	sp.kmass0 = 17.00219108;
	speciesDef.insert(pair<double, spcInfo>(17, sp));
	sp.reset();

	sp.name = "H2O";
	sp.kmass0 = 18.01001612;
	speciesDef.insert(pair<double, spcInfo>(18, sp));					// From nonGCU Mass Peak Search Table
	sp.reset();

	sp.name = "H2O";
	sp.kmass0 = 18.01001612;
	speciesDef.insert(pair<double, spcInfo>(18.16, sp));
	sp.reset();

	sp.name = "DHO";
	sp.kmass0 = 19.016841;
    speciesDef.insert(pair<double, spcInfo>(19, sp));
    sp.reset();

	sp.name = "Ne";
	sp.kmass0 = 19.992440;
    speciesDef.insert(pair<double, spcInfo>(20, sp));					// From GCU Mass Peak Search Table
    sp.reset();

	sp.name = "CO^2++";
	sp.kmass0 = 21.99354318;
    speciesDef.insert(pair<double, spcInfo>(21.98, sp));
    sp.reset();

	sp.name = "CO^2++";
	sp.kmass0 = 21.99354318;
    speciesDef.insert(pair<double, spcInfo>(22, sp));					// From nonGCU Mass Peak Search Table
    sp.reset();

    speciesDef.insert(pair<double, spcInfo>(23, sp));

	sp.name = "C2";
	sp.kmass0 = 23.99945142;
    speciesDef.insert(pair<double, spcInfo>(24, sp));					// From nonGCU Mass Peak Search Table
    sp.reset();

	sp.name = "C2";
	sp.kmass0 = 23.99945142;
    speciesDef.insert(pair<double, spcInfo>(24.18, sp));
    sp.reset();

	sp.name = "C2H";
	sp.kmass0 = 25.00727645;											// From GCU/nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(25, sp));
    sp.reset();

	sp.name = "CN";
	sp.kmass0 = 26.00252542;
    speciesDef.insert(pair<double, spcInfo>(26, sp));
    sp.reset();

	sp.name = "CHN";
	sp.kmass0 = 27.01035045;
    speciesDef.insert(pair<double, spcInfo>(27, sp));
    sp.reset();

	sp.name = "CO";
	sp.kmass0 = 27.994915;
    speciesDef.insert(pair<double, spcInfo>(28, sp));					// From GCU Mass Peak Search Table
    sp.reset();

	sp.name = "HCO";
	sp.kmass0 = 29.00219108;
    speciesDef.insert(pair<double, spcInfo>(29, sp));
    sp.reset();

	sp.name = "NO";
	sp.kmass0 = 29.99744005;
    speciesDef.insert(pair<double, spcInfo>(30, sp));
    sp.reset();

	sp.name = "O2";
	sp.kmass0 = 31.98928068;
    speciesDef.insert(pair<double, spcInfo>(32, sp));
    sp.reset();

    sp.name = "C3H";
    sp.kmass0 = 37.00727645;											// From GCU/nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(35.4, sp));
    sp.reset();

	sp.name = "C3";
	sp.kmass0 = 35.99945142;
    speciesDef.insert(pair<double, spcInfo>(36, sp));
    sp.reset();

    sp.name = "C3H";
   	sp.kmass0 = 37.00727645;											// From GCU/nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(37, sp));
    sp.reset();

    sp.name = "C3H3";
   	sp.kmass0 = 39.02292652;											// From GCU/nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(38.94, sp));
    sp.reset();

    sp.name = "C3H3";
    sp.kmass0 = 39.02292652;											// From GCU/nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(39, sp));
    sp.reset();

	sp.name = "CO2";
	sp.kmass0 = 43.98928068;											// nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(42.83, sp));
    sp.reset();

	sp.name = "CO2";
	sp.kmass0 = 43.98928068;
    speciesDef.insert(pair<double, spcInfo>(44, sp));					// From GCU/nonGCU Mass Peak Search Table
    sp.reset();

	sp.name = "^13CO2";
	sp.kmass0 = 44.992635;
    speciesDef.insert(pair<double, spcInfo>(45, sp));					// From GCU Mass Peak Search Table
    sp.reset();

	sp.name = "NO2";
	sp.kmass0 = 45.99235468;
    speciesDef.insert(pair<double, spcInfo>(46, sp));
    sp.reset();

	sp.name = "SO";
	sp.kmass0 = 47.96643675;											// From nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(47, sp));
    sp.reset();

	sp.name = "SO";
	sp.kmass0 = 47.96643675;											// From nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(47.12, sp));
    sp.reset();

	sp.name = "SO";
	sp.kmass0 = 47.96643675;											// From nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(48, sp));
    sp.reset();

	sp.name = "C4H2";
	sp.kmass0 = 50.01510149;											// From nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(50, sp));
    sp.reset();

	sp.name = "C4H3";
	sp.kmass0 = 51.02292652;											// From nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(51, sp));
    sp.reset();

	sp.name = "C4H5";
	sp.kmass0 = 53.03857659;											// From nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(51.83, sp));
    sp.reset();

	sp.name = "C4H5";
	sp.kmass0 = 53.03857659;											// From nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(53, sp));
    sp.reset();

	sp.name = "OCS";
	sp.kmass0 = 59.96643675;											// From nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(60, sp));
    sp.reset();

	sp.name = "OCS";
	sp.kmass0 = 59.96643675;											// From nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(62.72, sp));
    sp.reset();

    sp.name = "^128Xe^++";
    sp.kmass0 = 63.951491;
    speciesDef.insert(pair<double, spcInfo>(64, sp));					// From GCU Mass Peak Search Table
    sp.reset();

    sp.name = "^130Xe^++";
    sp.kmass0 = 64.951489;
    speciesDef.insert(pair<double, spcInfo>(65, sp));					// From GCU Mass Peak Search Table
    sp.reset();

    sp.name = "^132Xe^++";
    sp.kmass0 = 65.951798;
    speciesDef.insert(pair<double, spcInfo>(66, sp));					// From GCU Mass Peak Search Table
    sp.reset();

    sp.name = "^136Xe^++";
    sp.kmass0 = 67.953333;
    speciesDef.insert(pair<double, spcInfo>(68, sp));					// From GCU Mass Peak Search Table
    sp.reset();

    sp.name = "CS2";
    sp.kmass0 = 75.94359282;											// From nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(76, sp));
    sp.reset();

    sp.name = "CS2";
    sp.kmass0 = 78.046402;												// From nonGCU Mass Peak Search Table
    speciesDef.insert(pair<double, spcInfo>(75.89, sp));
    sp.reset();

    sp.name = "C6H6";
    sp.kmass0 = 78.046402;
    speciesDef.insert(pair<double, spcInfo>(78, sp));					// From nonGCU Mass Peak Search Table
    sp.reset();

    sp.name = "C7H7";
    sp.kmass0 = 91.05422666;
    speciesDef.insert(pair<double, spcInfo>(91, sp));					// From nonGCU Mass Peak Search Table
    sp.reset();

    sp.name = "C7H7";
    sp.kmass0 = 91.05422666;
    speciesDef.insert(pair<double, spcInfo>(91.83, sp));				// From nonGCU Mass Peak Search Table
    sp.reset();

    sp.name = "^129Xe";
    sp.kmass0 = 128.9042315;
    speciesDef.insert(pair<double, spcInfo>(129, sp));						// From GCU Mass Peak Search Table
    sp.reset();

    speciesDef.insert(pair<double, spcInfo>(130, sp));

    sp.name = "^131Xe";
    sp.kmass0 = 130.9050720;
    speciesDef.insert(pair<double, spcInfo>(131, sp));						// From GCU Mass Peak Search Table
    sp.reset();

    sp.name = "^132Xe";
    sp.kmass0 = 131.9035954;
    speciesDef.insert(pair<double, spcInfo>(132, sp));						// From GCU Mass Peak Search Table
    sp.reset();

    speciesDef.insert(pair<double, spcInfo>(133, sp));

    sp.name = "^134Xe";
    sp.kmass0 = 133.9048464;
    speciesDef.insert(pair<double, spcInfo>(134, sp));						// From GCU Mass Peak Search Table
    sp.reset();

    speciesDef.insert(pair<double, spcInfo>(135, sp));

    sp.name = "^136Xe";
    sp.kmass0 = 135.9066654;
    speciesDef.insert(pair<double, spcInfo>(136, sp));						// From GCU Mass Peak Search Table
    sp.reset();

}


