/*
 * DFMS_utility.h
 *
 *  Created on: Jan 15, 2013
 *      Author: marinaldi
 */

#ifndef DFMS_UTILITY_H_
#define DFMS_UTILITY_H_

#include <cstdlib>
#include <cctype>
#include <cstdio>
#include <cstring>
#include <ctime>

#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>

#include <dirent.h>
#include <errno.h>
#include <sys/types.h>

#include "DFMS_globals.hh"
#include "DFMS_structs.hh"

using namespace std;

extern int numL2Files;
extern int qlCount;
extern string sL2sourcePath;
extern vector<excludeInfo> dateExclusion;
extern vector<string> L2FileNames;

// Utility methods for various purposes
bool util_compare (const L2FileInfo &, const L2FileInfo &);
bool util_compare_date (const L2FileInfo &, const L2FileInfo &);
bool util_fileExists(string);
bool util_isalnum (const string &);
bool util_isFloat(const string&);
bool util_isInteger(const string&);
bool util_isNumber(const string&);
bool util_stringToBool(string);
double util_linIntrp(double, double, double, double, double);
double util_stringToDouble(string str);
int util_stringToInt(string);
string util_doubleToString(double);
string util_intToString(int);
void util_sortInt(int, int array[]);
void util_stats(double oavg[], int, statsInfo &);
string util_trim(const string&);
string util_trimChar(const string&, const string);
string util_trimEOL(string);
void util_splitString(const string &, char, vector<string> &);
void util_Tokenize(const string&, vector<string>&);
void util_toUpperCase (string &);

bool dateException(double);
double calToJD(int, int, int, int, int, double);
double rosToSec(string,int);
double timeDiffInSec(string, string);
string getProcessDate();
string getProcessTime(int);

void writeLine(fstream &, string, string, int);
void writeToLog(string, string, int );
void makeUpData(str2D &, str2D &, dbl2D & ,string, string);

bool isCalibL2File(L2FileInfo &L, string, bool);
double massToPix(double, double, double, double);
double massToPix0(double, double, double, double);
double pixToMass(double, double, double, double);
void massScale(double *, double, double, double, int, bool);
double calcDispersion(double);

void qlHeader();
void makePkPPMhisto();
void listModes();
void listCommMassStats();

string getDateFromFileName(string);

bool isEqual (double, double);
bool replace(string&, const string&, const string&);
int numUnique(const vector<double> &v);
long findNumFilesInDir(string, string);
string setTerminal();

void printLastLine(string, vector<string> &v);
void printxFVector (string, vector<x0FitInfo> &);

void checkOStype();

// Used by peakEclusion File reader
//pair<int,int> addPair(string, string);
//vector<pair<int,int>> addToVec(pair<int,int>);


#endif /* DFMS_UTILITY_H_ */
