; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;   Unauthorized reproduction prohibited.
;+
; NAME:
;   PRO p_delete_group, header, group, status
;
; PURPOSE:
;   Delete a complete GROUP or OBJECT cluster from a PDS header
;
; CALLING SEQUENCE:
;   p_delete_group, header, group, status
;
; INPUTS:
;   header:   Valid PDS header structure
;   group:  name of the GROUP or OBJECT structure to be deleted
;
; KEYWORD PARAMETERS:
;   NONE
;
; OUTPUTS:
;   status:  std status block ['S' or 'F' , 'SUCCESS' or 'FAILURE', <procedure>, <error message>]
;
; EXAMPLE:
;   p_read, pickfile(), h, d       ; read PDS file
;   p_delete_group, h, 'IMAGE', status  ; Delete the complete IMAGE object (and read status)
;
; MODIFICATION HISTORY:
;   Written by:  Stubbe F. Hviid, 11/8-2004
;-

PRO p_delete_group, header, group, status, _EXTRA=_EXTRA

    ; Start by setting status to success
    p_set_status, status, 'S', 'p_delete_group', ''

    ; Verify input
    if p_is_header(header) eq 0 then p_set_status, status, 'F', 'p_delete_group', 'Illegal PDS header'
    if n_elements(group) eq 0 then p_set_status, status, 'F', 'p_delete_group', 'You must specify a group path'

    if status[0] eq 'F' then return

	if NOT p_is_group(header, group) then begin
		print, 'Deleting non existing group ' + group
		return;
	endif


    ; find the group
    if p_find_group_range(header, group, start_index, end_index, _EXTRA=_EXTRA) ne 0 then begin

       if start_index gt 0 then begin
         tags = header.tags[0: start_index-1]
         values = header.values[0: start_index-1]
       endif

       if end_index le n_elements(header.tags)-1 then begin
         if n_elements(tags) eq 0 then begin
          tags = header.tags[end_index+1:*]
          values = header.values[end_index+1:*]
         endif else begin
          if end_index+1 lt n_elements(header.tags) then begin
          	tags = [tags, header.tags[end_index+1:*]]
          	values = [values, header.values[end_index+1:*]]
          endif
         endelse
       endif
    endif

    header = p_set_struct_tag(header, 'tags', tags, 'values', values)
END