; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	FUNCTION p_is_header, header
;
; PURPOSE:
;	Check if a variable contains a valid PDS header
;
; CALLING SEQUENCE:
;	  Result = p_is_header(header)
;
; INPUTS:
;	header:	The variable to be checked
;
; RETURNS:
;	1 if header contains a valid PDS header else 0
;
; EXAMPLE:
; 	h = p_newhead()
;	print, p_is_header(h)		; returns 1
;	print, p_is_header(10)		; returns 0
;
; MODIFICATION HISTORY:
; 	Written by:	Stubbe F. Hviid, 11/08-2004
;-

FUNCTION p_is_header, header

	if n_elements(header) eq 0 then return, 0

	if size(header, /TYPE) ne 8 then return, 0

	idx = where(tag_names(header) eq 'TYPE')

	if idx[0] lt 0 then return, 0

	if header.type ne 'TAGHDR' then return, 0

	idx = where(tag_names(header) eq 'TAGS')
	if idx[0] lt 0 then return, 0

	idx = where(tag_names(header) eq 'VALUES')
	if idx[0] lt 0 then return, 0

	return, 1
END