;+
; NAME:
;   p_parse_file_path
;
; PURPOSE:
;   Parse out the directory, filename and file extension parts of a fully qualified file path
;
; CATEGORY:
;   Filename handling
;
; CALLING SEQUENCE:
;   Result = p_parse_file_path(input_path)
;
;
; INPUTS:
;   input_path:   The fully qualified path to be parsed
;
;
; OUTPUTS:
;   Structure of form:  {dir: <directory>, name: <name wiathout extension>, ext: <file extension including .>, filename: <filename>}
;
; SIDE EFFECTS:
;   None
;
; RESTRICTIONS:
;   None
;
; EXAMPLE:
;   r = p_parse_file_path('/home/xxx/test.pro')
;
; MODIFICATION HISTORY:
;   Written by:  Stubbe F. Hviid  23/01-2004
;-

FUNCTION p_parse_file_path, path

    in_path = path

	l = strlen(in_path)
	c = strmid(in_path, l-1, 1)
	if c eq '\' OR c eq '/' then in_path = strmid(in_path, 0, l-1)

    ; look for certain path elements
    pb = strpos(in_path, '/', /REVERSE_SEARCH)
    pf = strpos(in_path, '\', /REVERSE_SEARCH)
    pe = strpos(in_path, '.', /REVERSE_SEARCH)

    ; seperate dir and filename
    if pb gt pf then pd = pb else pd = pf

    ; extract file extension
    if pe ge 0 AND pd lt pe then begin
       ext = strmid(in_path, pe)
       in_path = strmid(in_path, 0, pe)
    endif else begin
       ext = ''
    endelse



    if pd ge 0 then begin
       dir = strmid(in_path, 0, pd)
       name = strmid(in_path, pd+1)
    endif else begin
       dir = '.'
       name = in_path
    endelse

    return, {dir: dir, name: name, ext: ext, filename: name + ext}
END
