; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	FUNCTION p_read_stripe, sh, OK=OK
;
; PURPOSE:
;	Function for handling huge image data files. A stripeset is an interface for reading the image data in segments from the disk
;   small enough that the image data will fit in memory.
; 	The function supports PDS and VICAR images
;
;	p_read_stripe is the function for reading the next stripe set segment
;
; CALLING SEQUENCE:
;	 result = p_read_stripe(st, OK=OK)
;
; INPUTS:
;   st:			The structurte returned by p_open_stripeset()
;
; RETURNS:
;	An image matrix containing the image data
;
; KEYWORD PARAMETERS:
;	OK:		This keyword returns 1 on success and 0 on error
;
; EXAMPLE:
;	st = p_open_stripeset(pickfile(), 2000)		; open stripe set using 2000 liner per read cycle
;   ok=1
;   while ok do begin
; 		image = p_read_stripe(st, OK=ok)	; read a stripe segment OK returns 0 on read failure (end of image)
; 		if ok ne 0 then tvscl, image
;   endwhile
;   p_stripe_close, st
;
; MODIFICATION HISTORY:
; 	Written by:	Stubbe F. Hviid, 12/05-2004
;-
FUNCTION p_read_stripe, sh, OK=OK

	if sh.next_line ge sh.h then begin
		OK=0
		return, -1
	endif

	if sh.next_line + sh.stripe_height ge sh.h then begin
		h = sh.h-sh.next_line

	endif else begin
		h = sh.stripe_height
	endelse

	img = make_array(sh.w, h, TYPE=sh.datatype)

	readu, sh.unit, img
	sh.next_line = sh.next_line + h

	; check endian
	if sh.endian eq 'big' then byteorder, img, /SWAP_IF_LITTLE_ENDIAN else byteorder, img, /SWAP_IF_BIG_ENDIAN

	OK=1
	return, img
END