; Copyright (c) 2004, Stubbe F. Hviid.  All rights reserved.
;   Unauthorized reproduction prohibited.
;+
; NAME:
;   PRO p_delete_tag
;
; PURPOSE:
;   Delete a PDS label from a PDS header
;
; CALLING SEQUENCE:
;   PRO p_delete_tag, header, tag
;
; INPUTS:
;   header:   the pds header to be modified
;   tag:      the PDS tag to be deleted
;
; KEYWORD PARAMETERS:
;   NONE
;
; OUTPUTS:
;   NONE
;
; EXAMPLE:
;   p_read, pickfile(), h, d  ; read PDS file
;   p_delete, h, 'SOFTWARE_DESC'
;
; MODIFICATION HISTORY:
;   Written by:  Stubbe F. Hviid, 26/10-2004
;-
PRO p_delete_tag, header, tag
  if size(tag, /type) eq 7 then begin
    tmp = p_value(header, tag, FOUND=found, INDEX=index)
  endif else begin
    tag = fix(tag)
    if tag ge 0 AND tag lt n_elements(header.tags) then begin
      found = 1
      index = tag
    endif else found = 0
  endelse
  if found ne 0 then begin
    if index eq 0 then begin
      tags = header.tags[1:*]
      values = header.values[1:*]
    endif else if index ge n_elements(header.tags)-1 then begin
      tags = header.tags[0:index-1]
      values = header.values[1:index-1]
    endif else begin
      tags = [header.tags[0:index-1], header.tags[index+1:*]]
      values = [header.values[0:index-1], header.values[index+1:*]]
    endelse
    header = p_set_struct_tag(header, 'tags', tags, 'values', values)
  endif

END