FUNCTION p_pds_to_idl_var_string, pds_value, unit

	pds_value = strtrim(pds_value, 2)
	unit = ''
	vs = pds_value
	v = byte(strtrim(vs, 2))

	; convert '"' to '''
	s = where(v eq 34)
	if s[0] ge 0 then v[s] = 39


	; handle arrays
	if v[0] eq 40B then begin
		is_array = 1
		v = v[1: n_elements(v)-2]	; strip end brackets
		vs = string(v)

		tmp = strsplit(vs, ',', /EXTRACT)

		out = strarr(n_elements(tmp))
		unit = strarr(n_elements(tmp))

		for i=0L, n_elements(tmp)-1 do begin
			out[i] = p_pds_to_idl_var_string(tmp[i], vunit)
			unit[i] = vunit
		endfor
		return, out
	endif

	; handle scalars

	; check for other bases
	if v[n_elements(v)-1] eq 35B then begin
		p = strpos(vs, '#')
		base = uint(strmid(vs, 0, p))
		value = string(v[p+1:n_elements(v)-2])

		if base eq 16 then begin
			return, "'" + strtrim(value, 2) + "'UXL"
		endif
		if base eq 8 then begin
			return, "'" + strtrim(value, 2) + "'OUL"
		endif
		if base eq 2 then begin
			out = 0UL
			bit = 1UL
			value = byte(value)
			for i=n_elements(value)-1, 0, -1 do begin
				if value[i] eq 49B then out = out OR bit
				bit = bit * 2
			endfor
			return, strtrim(out, 2)
		endif
	endif

	; check for number

	; check for number
	if (v[0] ge 48B AND v[0] le 57) OR (v[0] eq 46B) OR (v[0] eq 45B) OR (v[0] eq 43B) then begin
		p = strpos(vs, '<')

		unit = ''
		if p gt 0 then begin
			p2 = strpos(vs, '>')
			unit = strmid(vs, p, p2 - p)
			vs = strmid(vs, 0, p-1)
		endif
		return, vs
	endif

	if v[0] eq 39B then vs = strmid(vs, 1, strlen(vs)-2)


	if v[0] eq 34B then return, vs

	;return, "'" + vs + "'"
	return, vs

END